<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit\Output;

use Drupal\panther\Phpunit\Context\TestClassInformation;
use Drupal\panther\Phpunit\Context\TestInformation;

interface FormatterInterface {

  public function testClassStart(TestClassInformation $class, int $current, int $total): string;

  public function testFinish(TestInformation $test): string;

  public function unexpectedOutput(string $output): string;

  public function errorBeforeMethod(string $message): string;

  public function deprecation(string $file, int $line, string $message): string;

}
