<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit\Subscribers;

use Drupal\panther\Phpunit\Context\TestContext;
use PHPUnit\Event\Test\BeforeTestMethodErrored;
use PHPUnit\Event\Test\BeforeTestMethodErroredSubscriber;

class TestBeforeMethodErroredSubscriber implements BeforeTestMethodErroredSubscriber {

  public function __construct(protected readonly TestContext $context) {
  }

  public function notify(BeforeTestMethodErrored $event): void {
    $this->context->markBeforeMethodErrored(
      $event->asString(),
    );
  }

}
