# Panther integration

Panther is a Drupal module that provides an integration with the [Panther library](https://symfony.com/doc/current/testing/end_to_end.html) for functional testing of web
applications. It allows you to write tests in PHP using the Panther API, which is built on top of the Symfony BrowserKit
and DomCrawler components.

## Installation

This is not a standalone module, but a library that can be used in your Drupal project. To install it, you can use
Composer:

```bash
composer require drupal/panther
```

You should not install this module.

## Configuration

Panther module is configured with some environment variables and a set of service container parameters.

### Environment variables

You can set the following environment variables to configure the Panther module:

- `PANTHER_DRUPAL_ROOT`: The absolute path to the Drupal root directory.
- `PANTHER_DRUPAL_HOST`: The URL to the Drupal site, e.g. `http://localhost:8080`.
- `PANTHER_SELENIUM_HOST`: The URL to the Selenium server, e.g. `http://localhost:4444/wd/hub`.
- `PANTHER_CONNECTION_TIMEOUT_MS`: The timeout in milliseconds for the connection to the Selenium server. Default is `5000`.
- `PANTHER_REQUEST_TIMEOUT_MS`: The timeout in milliseconds for the requests to the Selenium server. Default is `5000`.

### Service container parameters

You can set service parameters in a `panther.services.yml` file like:

```yaml
parameters:
  panther:
    screenshots_dir: '/var/www/html/web/sites/default/files/panther_screenshots'
    login_url: '/user/login'
    logout_url: '/user/logout'
    login_button: 'Log in'
    logout_button: 'Log out'
    username_field: 'name'
    password_field: 'pass'
    axe_script_url: 'https://cdnjs.cloudflare.com/ajax/libs/axe-core/4.10.3/axe.min.js'
    axe_tags: ['wcag2a', 'wcag2aa', 'wcag21a', 'wcag21aa']
    axe_best_practices: TRUE
    fail_on_axe_error: FALSE
```

You have to override the parameters according to your Drupal installation and the login/logout URLs you want to use. If
not specified, the default values will be used.

This file needs to be placed in the `web/sites/default` directory of your Drupal installation, and loaded in your
`settings.php` file:

```php
$settings['container_yamls'][] = DRUPAL_ROOT . '/web/sites/default/panther.services.yml';
```
