<?php

declare(strict_types=1);

namespace Drupal\panther\Phpunit\Enums;

enum TestStatus: string {

  case Errored = 'E';
  case Failed = 'F';
  case Incomplete = 'I';
  case Passed = 'P';
  case Risky = 'R';
  case Running = '-';
  case Skipped = 'S';
  case Warning = 'W';

  public function friendly(): string {
    return match ($this) {
      self::Errored => 'ERROR',
      self::Failed => 'FAILED',
      self::Incomplete => 'incomplete',
      self::Passed => 'pass',
      self::Risky => 'risky',
      self::Running => '...',
      self::Skipped => 'skipped',
      self::Warning => 'warning',
    };
  }

}
