# Paragraph Access

This module provides flexible access control for paragraphs on group pages with role-based and group membership restrictions. It allows both global paragraph type restrictions and per-paragraph access control, enabling site administrators to specify which paragraph types should be restricted to group members only, and content editors to restrict individual paragraphs on a case-by-case basis.

## Features

- Restrict access to specific paragraph types for non-members of a group (global configuration)
- Configure which paragraph types should be restricted
- Per-paragraph access control when adding paragraphs to group pages
- Restrict paragraphs to specific user roles
- Same paragraph type can be both accessible and restricted on different group pages
- Multiple paragraphs of the same type on the same group page can have different access settings
- Permission to bypass paragraph access restrictions
- Role-based access control with roles sorted by weight

## Installation

1. Install the module as you would normally install a Drupal module.
2. Go to `/admin/modules` and enable the "Paragraph Access" module.

## Configuration

### Global Configuration
1. Check the paragraph types that should be restricted to group members only.
2Save the configuration.

### Per-Paragraph Configuration
When adding or editing paragraphs on a group page, content editors will see two access control options for each paragraph:

1. **Show to Group Members ONLY** - A checkbox that allows them to:
   - Restrict access to a specific paragraph to group members only, even if its type is not globally restricted
   - Allow access to a specific paragraph, even if its type is globally restricted

2. **Show to Specific Roles ONLY** - A checkbox list of user roles that allows them to:
   - Restrict access to a specific paragraph to users with specific roles
   - The roles in the checkbox list are sorted by their weight, matching the order in the Drupal roles administration page

The access control logic between these two fields operates with an "OR" condition:
- If both restrictions are set, users will be granted access if they either have one of the specified roles OR are members of the group
- If only one restriction is set, users must meet that specific condition to access the paragraph

## Permissions

The module provides a permission "Bypass paragraph access restrictions" that allows users to view all paragraphs regardless of group membership. This permission can be assigned to roles at `/admin/people/permissions`.

## How it works

The module provides two levels of access control:

### 1. Per-Paragraph Access Control
When a paragraph is created or edited on a group page, content editors have two access control options:

1. **Show to Group Members ONLY** - A checkbox that restricts access to group members only
2. **Show to Specific Roles ONLY** - A checkbox list that restricts access to users with specific roles

These settings are stored with the paragraph entity and take precedence over global settings. If both settings are used on the same paragraph, access is granted if the user either has one of the specified roles OR is a member of the group (OR logic).

### 2. Global Type-Based Access Control
If a paragraph doesn't have a specific access setting, the module falls back to the global configuration, which restricts access based on paragraph type.

### Access Check Process
When a user tries to view a paragraph, the module:
1. First checks if the user has the "bypass paragraph access" permission
2. Then checks if the specific paragraph has either the "Show to Group Members ONLY" option enabled or has specific roles selected in the "Show to Specific Roles ONLY" field
3. If not, checks if the paragraph's type is globally restricted
4. If role-based restrictions apply, checks if the user has any of the specified roles
5. If group membership restrictions apply, checks if the user is a member of the associated group
6. If both role-based and group membership restrictions apply, grants access if the user either has one of the specified roles OR is a member of the associated group (OR logic)

The module checks the following group membership scenarios:
- If the paragraph's parent entity is a group, check if the user is a member of that group
- If the paragraph's parent entity is a group content entity, check if the user is a member of the associated group
- If the paragraph's parent entity belongs to one or more groups, check if the user is a member of any of those groups

This approach allows for flexible access control where:
- The same paragraph type can be both accessible and restricted on different group pages
- Multiple paragraphs of the same type on the same group page can have different access settings

## Requirements

- Drupal 9, 10, or 11
- Group module
- Paragraphs module
- Inline entity form module
