function paragroup($, context, settings) {
  const functions = {
    scrollToEl(el) {
      const offsetVal = el.offset().top - 95;
      window.scrollTo({
        top: offsetVal,
        behavior: 'smooth',
      });
    },
    resetBelow($button) {
      if ($button.hasClass('expanded')) {
        $button.click();
      } else {
        $button.click().click();
      }
    },
    expandBelowBulk() {
      const $ths = $(this);
      functions.resetBelow($ths);
      $ths.click();
    },
    collapseBelowBulk() {
      functions.resetBelow($(this));
    },
    setNestedExpanded($nestedButtons) {
      $nestedButtons
        .removeClass('collapsed')
        .addClass('expanded')
        .prop('value', 'Close Nested');
    },
    setNestedCollapsed($nestedButtons) {
      $nestedButtons
        .removeClass('expanded')
        .addClass('collapsed')
        .prop('value', 'Open Nested');
    },
    resetAllNested($button) {
      const $table = $button.closest('table');
      const $belowButtons = $table.find('.paragroup.toggle-below');
      const $nestedButtons = $table.find('.paragroup.toggle-nested');
      $belowButtons.each(function resetBelowButton() {
        functions.resetBelow($(this));
      });
      functions.setNestedCollapsed($nestedButtons);
    },
    buttonClicked(event, $ths) {
      if (!(event.originalEvent === undefined)) {
        if ($ths.hasClass('collapsed') && $ths.hasClass('toggle-below')) {
          functions.resetAllNested($ths);
        }
        functions.scrollToEl($ths.siblings('a'));
      }
    },
    paragraphHasSubParagraphs($paragraph) {
      let draggableRows = false;
      const $details = $paragraph
        .closest('table')
        .find('> tbody > tr > td > div > details');
      const detailsWidgetSel = '.field--widget-paragraph-group-details-widget';
      const $detailsWidget = $details.find(detailsWidgetSel);
      if ($detailsWidget.length) {
        const $tables = $detailsWidget.find('table');
        if ($tables.length) {
          $tables.each(function processTable() {
            const $table = $(this);
            const $rows = $table.find('> tbody > tr.draggable');
            if ($rows.length > 1) {
              draggableRows = true;
              return false;
            }
          });
        }
      }
      return draggableRows;
    },
    toggleBelow(event) {
      const $ths = $(this);
      event.preventDefault();
      const $details = $ths
        .closest('table')
        .find('> tbody > tr > td > div > details');
      if ($ths.hasClass('collapsed')) {
        $ths.prop('value', 'Close Below');
        $details.prop('open', true);
        $ths.removeClass('collapsed').addClass('expanded');
      } else if ($ths.hasClass('expanded')) {
        $ths.prop('value', 'Open Below');
        $details.prop('open', false);
        $ths.removeClass('expanded').addClass('collapsed');
      }
      functions.buttonClicked(event, $ths);
    },
    toggleNested(event) {
      const $ths = $(this);
      event.preventDefault();
      const $table = $ths.closest('table');
      const $belowButtons = $table.find('.paragroup.toggle-below');
      const $nestedButtons = $table.find('.paragroup.toggle-nested');
      if ($ths.hasClass('collapsed')) {
        functions.setNestedExpanded($nestedButtons);
        $belowButtons.each(functions.expandBelowBulk);
      } else if ($ths.hasClass('expanded')) {
        functions.resetAllNested($ths);
      }
      functions.buttonClicked(event, $ths);
    },
    toggleAll(event) {
      const $ths = $(this);
      event.preventDefault();
      const $belowButtons = $('.paragroup.toggle-below');
      const $nestedButtons = $('.paragroup.toggle-nested');
      if ($ths.hasClass('collapsed')) {
        $ths.prop('value', 'Close All Paragraphs');
        $ths.removeClass('collapsed').addClass('expanded');
        $belowButtons.each(functions.expandBelowBulk);
        functions.setNestedExpanded($nestedButtons);
      } else if ($ths.hasClass('expanded')) {
        $ths.prop('value', 'Open All Paragraphs');
        $ths.removeClass('expanded').addClass('collapsed');
        $belowButtons.each(functions.collapseBelowBulk);
        functions.setNestedCollapsed($nestedButtons);
      }
    },
    allButtonHtml() {
      const value = "'Open All Paragraphs'";
      const classes = "'button button--primary paragroup toggle-all collapsed'";
      const tooltip =
        "'This button opens / closes all the nested items " +
        "for all the paragraphs on this page.'";
      const allButton = `<input class=${classes} title=${tooltip} value=${value} readonly>`;
      return allButton;
    },
    shouldAppendAllButton() {
      const editParagroupSel = '#edit-group-paragraphs';
      const fieldGroupTabsWrapperSel = '.field-group-tabs-wrapper';
      const $editParagroup = $(editParagroupSel, context);
      const $fieldGroupTabsWrapper = $(fieldGroupTabsWrapperSel);
      const paragroupExists = $editParagroup.length > 0;
      const fieldGroupsExist = $fieldGroupTabsWrapper.length > 0;
      if (!paragroupExists && fieldGroupsExist) {
        return false;
      }
      return true;
    },
    findAllButtonRegion() {
      const editParagroupSel = '#edit-group-paragraphs';
      const $editParagroup = $(editParagroupSel, context);
      if ($editParagroup.length) {
        return $editParagroup;
      }
      let $regionEl = $('.layout-region-node-main', context);
      if (!$regionEl.length) {
        $regionEl = $('.layout-region--node-main', context);
      }
      if ($regionEl.length) {
        return $regionEl;
      }
      return null;
    },
    appendButtonToRegion($regionEl) {
      const tableSel = 'table.field-multiple-table';
      if ($regionEl.find(tableSel).length) {
        const $buttonAppended = $regionEl.find('.paragroup.toggle-all').length;
        if (!$buttonAppended) {
          const allButton = functions.allButtonHtml();
          $regionEl.prepend(allButton);
        }
      }
    },
    appendAllButton() {
      if (functions.shouldAppendAllButton()) {
        const $regionEl = functions.findAllButtonRegion();
        if ($regionEl) {
          functions.appendButtonToRegion($regionEl);
        }
      }
    },
    getParagraphEls() {
      const paragraphSel =
        '.field--widget-paragraph-group-details-widget ' +
        '> div > div > table > thead > tr > th.field-label';
      return $(paragraphSel, context);
    },
    belowButtonHtml() {
      const value = "'Open Below'";
      const classes = "'button button--small paragroup toggle-below collapsed'";
      const tooltip =
        "'This button opens / closes the items immediately below.'";
      const input = `<input class=${classes} title=${tooltip} value=${value} readonly>`;
      const belowButton = `<div class='paragroup button-wrapper'>
          <span class='buttons'>
            <a class='paragroup scrollto'></a>${input}
          </span>
        </div>`;
      return belowButton;
    },
    appendBelowButton() {
      const $paragraphEls = functions.getParagraphEls();
      const belowButton = functions.belowButtonHtml();
      $paragraphEls.each(function processParagraphEl() {
        const $element = $(this);
        const $belowAppended = $element.find(
          '.paragroup.button-wrapper',
        ).length;
        if (!$belowAppended) {
          $element.append(belowButton);
        }
      });
    },
    nestedButtonHtml() {
      const value = "'Open Nested'";
      const classes =
        "'button button--small paragroup toggle-nested collapsed'";
      const tooltip =
        "'This button opens / closes all the nested items in this paragraph.'";
      const nestedButton = `<input class=${classes} title=${tooltip}
         value=${value} readonly>`;
      return nestedButton;
    },
    appendNestedButton() {
      const $paragraphEls = functions.getParagraphEls();
      const nestedButton = functions.nestedButtonHtml();
      $paragraphEls.each(function processNestedParagraphEl() {
        const $element = $(this);
        const $nestedAppended = $element.find(
          '.paragroup.toggle-nested',
        ).length;
        const hasSubParagraphs = functions.paragraphHasSubParagraphs($element);
        if (!$nestedAppended && hasSubParagraphs) {
          $element
            .find('.paragroup.button-wrapper > .buttons')
            .append(nestedButton);
        }
      });
    },
    addHtmlClass(className) {
      const $html = $('html');
      if (!$html.hasClass(className)) {
        $html.addClass(className);
      }
    },
    getVerClass(drupalSettings) {
      const version = parseInt(drupalSettings.paragraph_group_ver, 11);
      let verClass;
      switch (version) {
        case 10:
          verClass = 'pg-d-ten';
          break;
        case 11:
        default:
          verClass = 'pg-d-eleven';
          break;
      }
      return verClass;
    },
    themeMods(drupalSettings) {
      const verClass = functions.getVerClass(drupalSettings);
      const configs = {
        paragraph_group_sc: 'pg-sidebar-config',
        paragraph_group_fwf: 'pg-full-width-forms',
        paragraph_group_ver: verClass,
      };
      $.each(configs, function processConfig(key, val) {
        if (drupalSettings.hasOwnProperty(key) && val) {
          functions.addHtmlClass(val);
        }
      });
    },
    confirmRemoval() {
      const confirmRemovalSel =
        '.paragraphs-dropbutton-wrapper .confirm-remove';
      const $confirmRemovalEl = $(confirmRemovalSel, context);
      if ($confirmRemovalEl.length) {
        const detailsSel = 'details.js-form-wrapper:not(.field-group-tab)';
        const $details = $confirmRemovalEl.parents(detailsSel);
        $details.prop('open', true);
      }
    },
    addedParagraph() {
      const newContentSel = '.draggable > td > .ajax-new-content';
      const $newContent = $(newContentSel, context);
      if ($newContent.length) {
        const $details = $newContent.find('> div > details');
        $details.prop('open', true);
      }
    },
    handleReturnToTop(event) {
      event.preventDefault();
      $(window).scrollTop(0);
    },
    appendReturnToTop() {
      const elementSel = '#edit-actions';
      const $elementEl = $(elementSel);
      const elementHtml =
        "<button class='link paragroup return-to-top'>Return to top</button>";
      if (!$('html .paragroup.return-to-top').length) {
        $elementEl.append(elementHtml);
      }
      $('html .paragroup.return-to-top').click(functions.handleReturnToTop);
    },
    init(drupalSettings) {
      functions.addHtmlClass('paragroup-on');
      functions.themeMods(drupalSettings);
      functions.confirmRemoval();
      functions.addedParagraph();
    },
    removeAjaxNewContentDiv() {
      const ajaxNewContentSel =
        '.field--widget-paragraph-group-details-widget .ajax-new-content > *';
      $(ajaxNewContentSel).unwrap();
    },
    appendButtons() {
      functions.removeAjaxNewContentDiv();
      functions.appendAllButton();
      functions.appendBelowButton();
      functions.appendNestedButton();
      functions.appendReturnToTop();
    },
    addToggleButtonEvents() {
      const events = {
        '.toggle-all': functions.toggleAll,
        '.toggle-below': functions.toggleBelow,
        '.toggle-nested': functions.toggleNested,
      };
      const processEvent = function processEvent(key, val) {
        const $buttons = $(key, context);
        const tea = 'toggle-events-added';
        $buttons.each(function processButton() {
          const $button = $(this);
          if (!$button.hasClass(tea)) {
            $button.click(val).addClass(tea);
          }
        });
      };
      $.each(events, processEvent);
    },
    main(drupalSettings) {
      functions.init(drupalSettings);
      functions.appendButtons();
      functions.addToggleButtonEvents();
    },
  };
  functions.main(settings);
}
(function initializeParagroupMain($) {
  Drupal.behaviors.paragraph_group = {
    attach(context, settings) {
      if (settings.hasOwnProperty('paragraph_group_details_widget')) {
        paragroup($, context, settings);
      }
    },
  };
})(jQuery);
