function paragroup($) {
  const functions = {
    openDetails(id) {
      const $detailsEl = $(id);
      if (!$detailsEl.attr('open')) {
        $detailsEl.attr('open', '');
      }
    },
    clickSelectAll(sectionId, deselect = false) {
      const $selectAll = $(`${sectionId} th.select-all input`);
      const title = $selectAll.attr('title');
      let titleComparison = null;
      if (!deselect) {
        titleComparison = 'Select all rows in this table';
      } else {
        titleComparison = 'Deselect all rows in this table';
      }
      if (title === titleComparison) {
        $selectAll.click();
      }
    },
    mainSections() {
      const sections = [
        '#edit-details-widget-boxes',
        '#edit-admin-titles-boxes',
        '#edit-field-groups-boxes',
      ];
      $.each(sections, functions.processSection);
    },
    themeMods() {
      const themeModsId = '#edit-theme-mods-boxes';
      functions.clickSelectAll(themeModsId, true);
      $('#edit-theme-mods-boxes-full-width-forms').prop('checked', true);
      $('#edit-theme-mods-boxes-sidebar-config')
        .removeAttr('disabled')
        .prop('checked', false);
      functions.openDetails(themeModsId);
    },
    recommendedConfig() {
      $('#pg-rec-config-link').click(functions.handleRecommendedConfig);
    },
    scAction() {
      const $sc = $('#edit-theme-mods-boxes-sidebar-config');
      const $fwf = $('#edit-theme-mods-boxes-full-width-forms');
      if ($fwf.prop('checked')) {
        $sc.removeAttr('disabled');
      } else {
        $sc.prop('checked', false).attr('disabled', 'disabled');
      }
    },
    sidebarConfig() {
      functions.scAction();
      $('#edit-theme-mods-boxes-full-width-forms').change(functions.scAction);
    },
    addClassToHtml(className) {
      const $html = $('html');
      if (!$html.hasClass(className)) {
        $html.addClass(className);
      }
    },
    main() {
      const $sa = $('#edit-theme-mods-boxes th.select-all input');
      if ($sa.length && !$('html').hasClass('pg-settings-complete')) {
        functions.recommendedConfig();
        functions.sidebarConfig();
        functions.addClassToHtml('pg-settings-complete');
      }
    },
    processSection(index, id) {
      functions.clickSelectAll(id);
      functions.openDetails(id);
    },
    handleRecommendedConfig(event) {
      event.preventDefault();
      functions.mainSections();
      functions.themeMods();
    },
  };
  functions.main();
}
(function initializeParagroupSettings($) {
  Drupal.behaviors.paragraph_group = {
    attach(context, settings) {
      if (settings.hasOwnProperty('paragraph_group_settings')) {
        paragroup($);
      }
    },
  };
})(jQuery);
