/**
 * TypeScript definitions for Drupal behaviors and settings.
 */

interface DrupalSettings {
  paragraph_group_details_widget?: boolean;
  paragraph_group_settings?: boolean;
  paragraph_group_ver?: string;
  paragraph_group_sc?: boolean;
  paragraph_group_fwf?: boolean;
  [key: string]: unknown;
}

interface DrupalBehavior {
  attach: (context: Document | HTMLElement, settings: DrupalSettings) => void;
  detach?: (context: Document | HTMLElement, settings: DrupalSettings, trigger: string) => void;
}

interface DrupalBehaviors {
  paragraph_group?: DrupalBehavior;
  [key: string]: DrupalBehavior | undefined;
}

interface Drupal {
  behaviors: DrupalBehaviors;
}

declare const Drupal: Drupal;
