# Paragraph Lineage

This module offers the following:
- Render a paragraph entity using the default view mode.
- Display the lineage of a paragraph entity.
- Provide a link to a paragraph lineage admin display in views such as file_usage or media admin.

## Table of Contents

- [Requirements](#requirements)
- [Installation](#installation)
- [Recommended modules](#recommended-modules)
- [Configuration](#configuration)
- [Maintainers](#maintainers)
- [License](#license)

## Requirements

- Drupal 10 or 11
- PHP 8.1 or higher
- *[Paragraphs](https://www.drupal.org/project/paragraphs)* contributed module installed and enabled.

## Recommended modules

- *Media*, core module for managing media entities.
- *File Usage*, core module for tracking file usage in the system.

## Installation

1. Run composer require drupal/paragraph_lineage to add the module to your project.
2. This will generate a view for paragraph_lineage.
3. Enable the module using Drush or the Drupal admin interface.

```sh
drush en paragraph_lineage
drush cr
```
## Configuration

This module does not have modifiable settings. It uses a default view mode (or preferably a preview) to render
paragraph entities for admin users.

It supplies a view mode for linking a paragraph entity in views such as file_usage or media entities.

## Maintainers

- [Chris Dart](https://www.drupal.org/u/chris-dart)

## License

This project is GPL-2.0-or-later licensed.
