<?php

declare(strict_types=1);

namespace Drupal\paragraph_lineage;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Service for managing paragraph lineage settings.
 */
final class ParagraphLineageSettingsService implements ParagraphLineageSettingsServiceInterface {

  const string CONFIG_NAME = 'paragraph_lineage.settings';

  /**
   * Constructs a ParagraphLineageSettingsService.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The configuration factory.
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getPreferredThemeId(bool $editable = FALSE): string {
    // Retrieve the preferred theme from the configuration.
    $config = $editable ? $this->configFactory->getEditable(self::CONFIG_NAME) : $this->configFactory->get(self::CONFIG_NAME);
    return $config->get('preferred_theme') ?? 'admin';
  }

  /**
   * {@inheritdoc}
   */
  public function isPreferredThemeOverridden(): bool {
    $immutable = $this->configFactory->get(self::CONFIG_NAME);
    $mutable = $this->configFactory->getEditable(self::CONFIG_NAME);
    return $immutable->get('preferred_theme') !== $mutable->get('preferred_theme');
  }

  /**
   * {@inheritdoc}
   */
  public function setPreferredThemeId(string $theme): void {
    // Set the preferred theme in the configuration.
    $config = $this->configFactory->getEditable(self::CONFIG_NAME);
    $config->set('preferred_theme', $theme)->save();
  }

}
