<?php

declare(strict_types=1);

namespace Drupal\paragraph_lineage;

/**
 * Interface for the Paragraph Lineage settings service.
 */
interface ParagraphLineageSettingsServiceInterface {

  /**
   * Get the preferred theme for displaying a paragraph.
   *
   * @param bool $editable
   *   If TRUE, returns an editable configuration object.
   */
  public function getPreferredThemeId(bool $editable = FALSE): string;

  /**
   * Set the preferred theme for displaying a paragraph.
   *
   * @param string $theme
   *   The machine name of the theme to set as preferred.
   * */
  public function setPreferredThemeId(string $theme): void;

  /**
   * Check if the preferred theme has been overridden.
   *
   * @return bool
   *   Returns TRUE if the preferred theme is different from the default.
   *
   *   This checks if the preferred theme is different from the default
   *   or admin theme, indicating that it has been explicitly set.
   */
  public function isPreferredThemeOverridden(): bool;

}
