<?php

namespace Drupal\Tests\paragraph_lineage\Unit;

use Drupal\Component\Render\MarkupInterface;
use Drupal\Core\Entity\EntityDisplayRepositoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Entity\EntityViewBuilderInterface;
use Drupal\Core\Render\Markup;
use Drupal\Core\Render\RendererInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\paragraphs\ParagraphInterface;
use Drupal\Tests\UnitTestCase;
use Drupal\paragraph_lineage\Controller\ParagraphLineageViewController;
use Drupal\node\NodeInterface;

/**
 * @coversDefaultClass \Drupal\paragraph_lineage\Controller\ParagraphLineageViewController
 * @group paragraph_lineage
 */
class ParagraphLineageViewControllerTest extends UnitTestCase {

  /**
   * @covers ::build
   * @throws \PHPUnit\Framework\MockObject\Exception
   * @throws \Drupal\Core\Entity\EntityMalformedException
   */
  public function testBuild() {
    // Mock the dependencies.
    $route_match = $this->createMock(RouteMatchInterface::class);
    $renderer = $this->createMock(RendererInterface::class);
    $paragraph = $this->createMock(ParagraphInterface::class);
    $parent_node = $this->createMock(NodeInterface::class);
    $entity_type_manager = $this->createMock(EntityTypeManagerInterface::class);
    $entity_display_repository = $this->createMock(EntityDisplayRepositoryInterface::class);
    $view_builder = $this->createMock(EntityViewBuilderInterface::class);

    // Set up the expectations for the mocks.
    $route_match->expects($this->any())
      ->method('getParameter')
      ->with('paragraph')
      ->willReturn($paragraph);

    $paragraph->expects($this->any())
      ->method('getEntityTypeId')
      ->willReturn('paragraph');

    $paragraph->expects($this->any())
      ->method('bundle')
      ->willReturn('default');

    $paragraph->expects($this->any())
      ->method('getParentEntity')
      ->willReturn($parent_node);

    $parent_node->expects($this->any())
      ->method('getEntityTypeId')
      ->willReturn('node');

    $parent_node->expects($this->any())
      ->method('bundle')
      ->willReturn('page');

    $parent_node->expects($this->any())
      ->method('label')
      ->willReturn('Parent Node');

    $parent_node->expects($this->any())
      ->method('id')
      ->willReturn(1);

    $entity_type_manager->expects($this->any())
      ->method('getViewBuilder')
      ->willReturnMap([
        ['paragraph', $view_builder],
        ['node', $view_builder],
      ]);

    $view_builder->expects($this->any())
      ->method('view')
      ->willReturnCallback(function ($entity, $view_mode) {
        return ['#markup' => 'Rendered ' . $entity->getEntityTypeId()];
      });

    $renderer->expects($this->any())
      ->method('render')
      ->willReturn(Markup::create('Rendered paragraph'));

    $entity_display_repository->expects($this->any())
      ->method('getViewModes')
      ->willReturn(['default' => 'default']);

    // Create a partial mock to override the inherited entityTypeManager method.
    $controller = $this->getMockBuilder(ParagraphLineageViewController::class)
      ->setConstructorArgs([$renderer, $route_match, $entity_display_repository])
      ->onlyMethods(['entityTypeManager'])
      ->getMock();

    $controller->expects($this->any())
      ->method('entityTypeManager')
      ->willReturn($entity_type_manager);

    // Call the build method and assert the result.
    $result = $controller->build();
    $this->assertArrayHasKey('#theme', $result);
    $this->assertArrayHasKey('#paragraph', $result);
    $this->assertArrayHasKey('#lineage', $result);
    $this->assertEquals('paragraph_lineage', $result['#theme']);
    $this->assertInstanceOf(MarkupInterface::class, $result['#paragraph']['content']);
  }

}
