<?php

namespace Drupal\Tests\paragraph_lineage\Unit\Plugin\Field\FieldFormatter;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\TypedData\ComplexDataDefinitionInterface;
use Drupal\Core\TypedData\TraversableTypedDataInterface;
use Drupal\Core\TypedData\TypedDataInterface;
use Symfony\Component\Validator\ConstraintViolationListInterface;

/**
 * Mock implementation of FieldItemInterface for testing.
 */
class MockFieldItem implements FieldItemInterface, \IteratorAggregate {

  /**
   * The value of the field item.
   *
   * @var mixed
   */
  public mixed $value;

  /**
   * The entity containing this field item.
   *
   * @var \Drupal\Core\Entity\EntityInterface
   */
  protected EntityInterface $entity;

  /**
   * Constructs a new MockFieldItem.
   *
   * @param mixed $value
   *   The value for this field item.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity that contains this field item.
   */
  public function __construct(mixed $value, EntityInterface $entity) {
    $this->value = $value;
    $this->entity = $entity;
  }

  /**
   * {@inheritdoc}
   */
  public function __get($property_name) {
    if ($property_name === 'value') {
      return $this->value;
    }
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function __set($property_name, $value) {
    if ($property_name === 'value') {
      $this->value = $value;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function __isset($property_name) {
    return $property_name === 'value';
  }

  /**
   * {@inheritdoc}
   */
  public function __unset($property_name) {
    if ($property_name === 'value') {
      $this->value = NULL;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getEntity(): EntityInterface {
    return $this->entity;
  }

  /**
   * {@inheritdoc}
   */
  public function getValue() {
    return ['value' => $this->value];
  }

  /**
   * {@inheritdoc}
   */
  public function setValue($value, $notify = TRUE): void {
    if (isset($value['value'])) {
      $this->value = $value['value'];
    }
    elseif (!is_array($value)) {
      $this->value = $value;
    }
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty(): bool {
    return empty($this->value);
  }

  /**
   * {@inheritdoc}
   */
  public function getFieldDefinition(): ?FieldDefinitionInterface {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getParent(): ?TraversableTypedDataInterface {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function setContext($name = NULL, ?TraversableTypedDataInterface $parent = NULL) {
    // Not implemented.
  }

  /**
   * {@inheritdoc}
   */
  public function onChange($name, $notify = TRUE) {
    // Not implemented.
  }

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function mainPropertyName(): ?string {
    return 'value';
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getLangcode(): string {
    return 'en';
  }

  /**
   * {@inheritdoc}
   */
  public function view($display_options = []): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function preSave() {
    // Not implemented.
  }

  /**
   * {@inheritdoc}
   */
  public function postSave($update): bool {
    // Not implemented.
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function delete() {
    // Not implemented.
  }

  /**
   * {@inheritdoc}
   */
  public function deleteRevision() {
    // Not implemented.
  }

  /**
   * {@inheritdoc}
   */
  public static function generateSampleValue(FieldDefinitionInterface $field_definition): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function defaultStorageSettings(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function defaultFieldSettings(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function storageSettingsSummary(FieldStorageDefinitionInterface $storage_definition): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function fieldSettingsSummary(FieldDefinitionInterface $field_definition): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function storageSettingsToConfigData(array $settings): array {
    return $settings;
  }

  /**
   * {@inheritdoc}
   */
  public static function storageSettingsFromConfigData(array $settings): array {
    return $settings;
  }

  /**
   * {@inheritdoc}
   */
  public function getIterator(): \Traversable {
    return new \ArrayIterator([$this->value]);
  }

  /**
   * {@inheritdoc}
   */
  public static function fieldSettingsToConfigData(array $settings): array {
    return $settings;
  }

  /**
   * {@inheritdoc}
   */
  public static function fieldSettingsFromConfigData(array $settings): array {
    return $settings;
  }

  /**
   * {@inheritdoc}
   */
  public function storageSettingsForm(array &$form, FormStateInterface $form_state, $has_data): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function fieldSettingsForm(array $form, FormStateInterface $form_state): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function calculateDependencies(FieldDefinitionInterface $field_definition): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function calculateStorageDependencies(FieldStorageDefinitionInterface $field_storage_definition): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function onDependencyRemoval(FieldDefinitionInterface $field_definition, array $dependencies): bool {
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function getDataDefinition(): ?ComplexDataDefinitionInterface {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getString(): string {
    return (string) $this->value;
  }

  /**
   * {@inheritdoc}
   */
  public function getConstraints(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function validate(): ?ConstraintViolationListInterface {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function applyDefaultValue($notify = TRUE): TypedDataInterface|MockFieldItem|static {
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getName(): int|string|null {
    return '';
  }

  /**
   * {@inheritdoc}
   */
  public function getRoot(): TraversableTypedDataInterface|static {
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getPropertyPath(): string {
    return '';
  }

  /**
   * {@inheritdoc}
   */
  public static function createInstance($definition, $name = NULL, ?TraversableTypedDataInterface $parent = NULL): null {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function get($property_name): ?TypedDataInterface {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function set($property_name, $value, $notify = TRUE): MockFieldItem {
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getProperties($include_computed = FALSE): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function toArray(): array {
    return ['value' => $this->value];
  }

}
