# Paragraph SDC

**Bridge your existing Drupal content into Canvas**

Have a lot of paragraph types? Bring them into Canvas without rebuilding.

## The Problem

Drupal Canvas is powerful, but requires creating everything from scratch. If you have hundreds of paragraph types and thousands of instances, migration feels impossible. Your content editors are stuck: they can see great content in the old system but can't use it in Canvas pages.

## The Solution

This module provides Canvas components that display any existing Drupal entity:

- Drag `paragraph-sdc` onto your Canvas page
- Enter the paragraph ID
- Your content appears immediately
- Edit originals with contextual links (new in v2.0!)

**Result:** Your entire paragraph library becomes Canvas-ready in minutes, not months.

---

## Features

### Primary Use: Canvas Integration

**Instant Content Reuse**
- Works with paragraphs, nodes, users, taxonomy terms, comments, files, blocks, and more
- No code changes to existing content
- Content editors find IDs and drop them into Canvas

**Contextual Edit Links (v2.0)**
- Pencil icon appears in Canvas preview mode
- Click to edit original content in new tab
- Located in upper-left corner of rendered entities
- Seamless workflow for content teams

### Secondary Use: SDC on Paragraph Pages

**SDC Paragraph Type**
- Display any Single Directory Component as a Paragraph
- Pass custom properties via JSON
- Use SDCs on traditional Paragraph-based pages
- No Canvas required

### Developer Bonus: Paragraph Routes

Version 2.0 adds `/paragraph/{id}` and `/paragraph/{id}/edit` routes - giving paragraphs URL patterns like other entities. These missing links bring paragraphs into the Drupal party as first-class entities.

---

## Quick Start

### Installation

```bash
drush en paragraphs twig_tweak
drush en paragraph_sdc
drush cr
```

Or via Composer:

```bash
composer require 'drupal/paragraph_sdc:^2.0'
```

### Using in Canvas (Primary Use Case)

#### Step 1: Find Your Entity ID

**For Nodes, Blocks, Users:**
- Navigate to admin listing (`/admin/content`)
- Hover over Edit link
- ID appears in URL: `/node/123/edit`

**For Paragraphs (if themed with ID):**
- Inspect HTML element
- Look for `id="paragraph-41544"`

**For Paragraphs (with Paragraphs Edit module):**
- Click the pencil icon on any paragraph
- Hover over Edit in the menu
- URL shows: `/node/456/paragraph/41544/edit`
- The number after `/paragraph/` is your paragraph ID

**For Paragraphs (if ID not showing):**
Your paragraph template needs theming. Add this to your paragraph template:
```twig
id="paragraph-{{ paragraph.id() }}"
```

#### Step 2: Add to Canvas

1. In Canvas Editor, click the **+** in the left sidebar
2. Look under **Other** for **Paragraph SDC**
3. Drag it onto your page
4. In Properties panel (right side):
   - **Entity Type:** paragraph
   - **View Mode:** full
   - **ID:** [your paragraph ID]
5. Your paragraph renders immediately

#### Step 3: Edit Original Content

1. Switch to Preview mode
2. Notice pencil icon in upper-left corner
3. Click to edit original paragraph in new tab
4. Changes appear immediately in Canvas

---

## Advanced Usage

### Canvas: Entity SDC Component

For developers who need maximum flexibility:

```
Entity Type: custom_entity_type (free-form text input)
View Mode: custom_view_mode (free-form text input)
ID: 555
```

Perfect for custom entity types not in the dropdown list.

### Traditional Paragraphs: SDC Paragraph Type

Display any SDC component on non-Canvas pages:

1. Add field to your content type: Entity Reference Revisions → Paragraph
2. Enable "SDC Paragraph" type in field settings
3. Create/edit content, add SDC Paragraph
4. Enter SDC name: `theme_name:component_name`
5. Enter properties (JSON format):
```json
{
  "title": "Welcome",
  "subtitle": "Discover amazing content",
  "button_text": "Get Started"
}
```

The component renders with your custom properties.

### Twig Templates: Direct Include

For themers working outside Canvas:

```twig
{# Using Paragraph SDC #}
{% include 'paragraph_sdc:paragraph-sdc' with {
  id: 12345
} %}

{# Using Entity SDC #}
{% include 'paragraph_sdc:entity-sdc' with {
  entity_type: 'node',
  id: 67890,
  view_mode: 'teaser'
} %}
```

**Note:** This is a developer-focused feature. Most users will use Canvas integration or SDC Paragraphs instead.

---

## Finding Entity IDs - Complete Guide

### Nodes, Blocks, Users, Terms

Visit the admin listing:
- `/admin/content` (nodes)
- `/admin/content/block` (blocks)
- `/admin/people` (users)
- `/admin/structure/taxonomy/manage/tags/overview` (terms)

Hover over or click Edit → ID appears in URL.

### Paragraphs (Themed with ID Attribute)

Inspect the HTML element:
```html
<section id="paragraph-41544" ...>
```

The number after `paragraph-` is your ID.

### Paragraphs (Using Paragraphs Edit Module)

**Recommended method for sites with many paragraphs:**

1. Install Paragraphs Edit module: https://www.drupal.org/project/paragraphs_edit
2. Each paragraph gets a contextual pencil icon
3. Click pencil → hover Edit link
4. URL format: `/node/[node-id]/paragraph/[paragraph-id]/edit`
5. The number after `/paragraph/` is what you need

Example URL: `/node/456/paragraph/41544/edit`  
→ Paragraph ID is `41544`

### Paragraphs (Not Themed)

If you see this HTML:
```html
<section id="paragraph-" ...>
```

Your paragraphs need theming. Add to your paragraph template:

**Generic paragraph template** (`paragraph.html.twig`):
```twig
<div id="paragraph-{{ paragraph.id() }}" class="paragraph">
  {{ content }}
</div>
```

**Specific paragraph type** (`paragraph--your-type.html.twig`):
```twig
<section id="paragraph-{{ paragraph.id() }}" class="my-custom-paragraph">
  {# your existing template code #}
</section>
```

Clear cache, and IDs will appear in HTML.

---

## Troubleshooting

### Pencil Icon Not Appearing

**Check 1:** Are you in Preview mode?  
Pencil only shows in `/canvas/preview/` - not in Edit mode

**Check 2:** Is `canvas_is_preview` available?  
The component needs Canvas context to detect preview mode

### Content Not Rendering

**Check 1:** Is Twig Tweak enabled?  
```bash
drush en twig_tweak
```

**Check 2:** Is the entity ID correct?  
Verify at `/paragraph/[id]` or `/node/[id]`

**Check 3:** Does the entity exist?  
Check admin listing for the entity

### Pencil Icon Not Clickable

**This is expected in Edit mode.** Canvas doesn't allow link clicks in `/canvas/editor/` because clicks activate objects. The pencil is intentionally hidden in Edit mode and only appears in Preview where it's clickable.

---

## Architecture

### Components Included

**paragraph-sdc** - User-friendly Canvas component with dropdown selections  
**entity-sdc** - Developer Canvas component with text inputs  
**sdc_paragraph** - Paragraph type for displaying SDCs

### Dependencies

- Drupal 10.x or 11.x
- Paragraphs module
- Twig Tweak module
- Drupal Canvas (for Canvas features)

### How It Works

The module leverages:
- Drupal's entity system
- Twig Tweak's `drupal_entity()` function
- Canvas preview context detection
- JavaScript parent window detection for contextual links

---

## Version 2.0 Changelog

**New Features:**
- Contextual edit links with pencil icons in Canvas preview
- Paragraph routes: `/paragraph/{id}` and `/paragraph/{id}/edit`
- Smart preview detection (hidden in Edit, visible in Preview)

**Improvements:**
- Enhanced documentation
- Better error handling
- Clearer property labels in Canvas

---

## Roadmap

This module is considered feature-complete and is in maintenance mode. Current features cover the primary use cases:
- Existing content in Canvas ✓
- SDCs in Paragraphs ✓
- Contextual editing ✓
- Paragraph routes ✓

---

## Support

- Issue queue: https://www.drupal.org/project/issues/paragraph_sdc
- For Drupal Canvas support: https://www.drupal.org/project/canvas

---

## Credits

**Maintainer:** seth snyder  
**License:** GPL-2.0-or-later

---

## Related Projects

- **Drupal Canvas** - The page builder this module integrates with
- **Paragraphs** - The entity system we're bridging
- **Paragraphs Edit** - Adds contextual edit links to paragraphs (recommended)
- **Twig Tweak** - Required dependency for entity rendering
- **SDC Styleguide** - Browse and preview all your SDCs
