# Paragraph Usage Dashboard - Drupal.org Project Description

## Short Description
Provides a powerful visual dashboard of Paragraph Types and where they are used, displaying icons, content types, and path aliases of parent entities.

## Full Description

Paragraph Usage Dashboard is a Drupal 11 contrib module that helps site administrators and content managers understand how paragraph types are being used across their site.

### Key Features

- **Visual Dashboard** - Clean, intuitive interface showing all paragraph usage at a glance
- **Paragraph Type Icons** - Displays configured icons for easy visual identification
- **Content Type Usage** - Shows which content types utilize each paragraph type
- **Path Aliases Display** - Lists actual path aliases instead of numeric IDs
- **Quick Access Links** - View buttons for instant navigation to parent entities
- **Smart Filtering** - Multi-select filter to display only specific paragraph types
- **Drill-Down Detail Views** - Click any paragraph type to see comprehensive instance-level details
- **Modern Architecture** - Built with Drupal 11 OOP standards, services, and dependency injection

### Use Cases

- **Content Audits** - Quickly identify which paragraphs are being used and where
- **Content Migration** - Understand paragraph distribution before migration
- **Content Strategy** - Make informed decisions about paragraph type management
- **Quality Assurance** - Verify paragraph types are being used appropriately
- **Training** - Help editors understand content structure and usage patterns
- **Maintenance** - Identify unused paragraph types that can be safely removed

### Dashboard Details

The main dashboard (`/admin/reports/paragraph-usage`) displays:

1. **Icon Column** - Visual representation from paragraph type configuration
2. **Paragraph Type** - Clickable name linking to detail view
3. **Used in Content Type(s)** - All content types utilizing this paragraph
4. **Path Alias(es)** - Human-readable URLs of parent entities (shows first 5, with count of additional)
5. **View Link** - Direct access to the first parent entity

### Detail View

Click any paragraph type to see:

- Entity titles using the paragraph
- Content type/bundle information
- Field name where paragraph appears
- Path alias for each instance
- View link for each parent entity

### Technical Highlights

- **No Database Changes** - Works with existing Drupal infrastructure
- **Performance Optimized** - Efficient entity queries with access checks
- **Extensible Design** - Service-based architecture for easy customization
- **Drupal 11 Ready** - Uses latest OOP hook system and coding standards
- **Accessible** - Semantic HTML and proper ARIA attributes
- **Responsive Design** - Works on all device sizes

### Requirements

- Drupal ^11
- Paragraphs module ^1.0
- PHP 8.1+

### Installation

1. Install via Composer: `composer require drupal/paragraph_usage_dashboard`
2. Enable the module: `drush en paragraph_usage_dashboard`
3. Grant "Access paragraph usage dashboard" permission
4. Navigate to Reports > Paragraph Usage

### Permissions

- **access paragraph usage dashboard** - Required to view dashboard and reports (restricted by default)

### Architecture

This module follows modern Drupal 11 best practices:

- **Services** - `ParagraphUsageCollector` for data collection
- **Controllers** - Separate controllers for dashboard and detail views
- **Forms** - Form API for filtering functionality
- **OOP Hooks** - Modern hook implementation via attributes
- **Dependency Injection** - Throughout the codebase
- **Twig Templates** - Themeable output
- **State API** - Persistent filter selection

### Why This Module?

While the Paragraphs module provides excellent content structuring capabilities, it lacks visibility into how paragraph types are being used across a site. This module fills that gap by providing:

- Real-time usage data without complex queries
- Visual interface accessible to non-technical users
- Path alias display instead of cryptic node IDs
- Quick navigation to see paragraphs in context
- Filtering for focused analysis

### Roadmap

Future enhancements under consideration:

- Export functionality (CSV, Excel)
- Usage statistics and charts
- Unused paragraph type detection
- Bulk operations on paragraph instances
- Integration with other reporting modules
- Configuration options for display preferences

### Support

- Issue Queue: https://www.drupal.org/project/issues/paragraph_usage_dashboard
- Documentation: See README.md in module directory
- Source Code: https://git.drupalcode.org/project/paragraph_usage_dashboard

### Contributing

Contributions are welcome! Please follow Drupal coding standards and submit patches through the issue queue.

### License

GPL-2.0-or-later

---

**Project Type:** Module
**Maintenance Status:** Actively maintained
**Development Status:** New project (1.0.0)
**Category:** Content, Administration, Reporting
**Tags:** paragraphs, reporting, dashboard, content audit, usage tracking
