(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.paragraphUsageDashboard = {
    attach: function (context, settings) {
      // Add any interactive behaviors here
      $('.paragraph-usage-dashboard-table', context).once('paragraphUsageDashboard').each(function () {
        // Table is now enhanced
        $(this).addClass('enhanced');
      });

      // Enable sorting or filtering if needed
      $('.paragraph-detail-table', context).once('paragraphDetailTable').each(function () {
        $(this).addClass('enhanced');
      });

      // Copy path to clipboard functionality
      $('.copy-path-btn', context).once('copyPath').on('click', function (e) {
        e.preventDefault();
        var path = $(this).data('path');
        var button = $(this);

        if (navigator.clipboard && navigator.clipboard.writeText) {
          navigator.clipboard.writeText(path).then(function () {
            // Show success feedback
            var originalText = button.text();
            button.text(Drupal.t('Copied!')).addClass('success');

            setTimeout(function () {
              button.text(originalText).removeClass('success');
            }, 2000);
          }).catch(function (err) {
            console.error('Failed to copy:', err);
            alert(Drupal.t('Failed to copy path'));
          });
        } else {
          // Fallback for older browsers
          var tempInput = $('<input>');
          $('body').append(tempInput);
          tempInput.val(path).select();
          document.execCommand('copy');
          tempInput.remove();

          var originalText = button.text();
          button.text(Drupal.t('Copied!')).addClass('success');

          setTimeout(function () {
            button.text(originalText).removeClass('success');
          }, 2000);
        }
      });
    }
  };

})(jQuery, Drupal);
