# Paragraph Usage Dashboard - Quick Start Guide

## Installation (30 seconds)

```bash
# Using Composer (recommended)
composer require drupal/paragraph_usage_dashboard

# Enable the module
drush en paragraph_usage_dashboard -y

# Or via UI: Admin > Extend > Enable "Paragraph Usage Dashboard"
```

## Grant Permissions (10 seconds)

Navigate to: **Admin > People > Permissions**

Grant **"Access paragraph usage dashboard"** to appropriate roles (e.g., Content Admin, Site Admin)

## Access the Dashboard (5 seconds)

Navigate to: **Admin > Reports > Paragraph Usage**

Or directly: `https://yoursite.com/admin/reports/paragraph-usage`

## What You'll See

### Main Dashboard Table

| Column | Description |
|--------|-------------|
| **Icon** | Visual representation of paragraph type |
| **Paragraph Type** | Name (clickable for details) |
| **Used in Content Type(s)** | Which content types use this paragraph |
| **Path Alias(es)** | Human-readable URLs of pages using this paragraph |
| **View** | Quick link to view a page using this paragraph |

### Example Row
```
| [image] | Hero Banner | Page, Article | /about, /home, /services | [View] |
```

## Using the Filter

1. Click **"Filter Paragraph Types"** to expand
2. Check the paragraph types you want to see
3. Click **"Apply Filter"**
4. Click **"Reset Filter"** to show all types again

Your filter selection is saved automatically.

## Viewing Details

Click on any **Paragraph Type name** to see:

- Every instance where that paragraph is used
- The specific content item (entity title)
- Which content type it belongs to
- Which field contains the paragraph
- The path alias
- A view link

## Common Use Cases

### Content Audit
"Which pages use the 'Call to Action' paragraph?"
→ Click "Call to Action" to see all instances

### Content Migration
"How many places use the old 'Legacy Banner' paragraph?"
→ View the dashboard, find "Legacy Banner" row, click to see all uses

### Quality Assurance
"Are editors using the new 'Featured Content' paragraph?"
→ Check the dashboard for "Featured Content" entries

### Content Strategy
"Which paragraph types are most/least used?"
→ View the dashboard to see path alias counts

### Cleanup
"Can we safely remove the 'Deprecated Hero' paragraph type?"
→ Check if any path aliases are listed for it

## Keyboard Navigation

- **Tab** - Move between elements
- **Enter** - Follow links
- **Space** - Toggle checkboxes

## Tips & Tricks

1. **No usage showing?**
   - Ensure content exists using the paragraph types
   - Clear Drupal cache: `drush cr`

2. **Missing icons?**
   - Icons must be configured in paragraph type settings
   - Go to: Admin > Structure > Paragraph types > [Type] > Edit

3. **Large sites**
   - Use the filter to focus on specific paragraph types
   - This improves page load performance

4. **Export data**
   - Currently: Copy/paste from browser
   - Future: Export features planned

## Troubleshooting

### "Access Denied" Error
**Solution:** Grant "Access paragraph usage dashboard" permission

### Empty Dashboard
**Solution:**
- Verify paragraphs module is enabled
- Check that paragraph types exist
- Ensure content uses those paragraph types

### Icons Not Displaying
**Solution:**
- Configure icons in paragraph type settings
- Verify icon files exist and are accessible

### Wrong Path Aliases
**Solution:**
- Check path alias configuration
- Rebuild URL aliases if needed

## For Developers

### Service Access
```php
$collector = \Drupal::service('paragraph_usage_dashboard.collector');
$usage_data = $collector->collectUsageData();
```

### Custom Integration
```php
// Get usage for specific type
$collector = \Drupal::service('paragraph_usage_dashboard.collector');
$hero_usage = $collector->getDetailedUsage('hero_banner');
```

### Theming
Override templates in your theme:
```
mytheme/templates/paragraph-usage-dashboard.html.twig
mytheme/templates/paragraph-usage-detail.html.twig
```

### Adding Custom Styles
```yaml
# mytheme.libraries.yml
paragraph-dashboard-override:
  css:
    theme:
      css/paragraph-dashboard-custom.css: {}
  dependencies:
    - paragraph_usage_dashboard/dashboard
```

## Routes Reference

| Route | Path | Purpose |
|-------|------|---------|
| `paragraph_usage_dashboard.dashboard` | `/admin/reports/paragraph-usage` | Main dashboard |
| `paragraph_usage_dashboard.detail` | `/admin/reports/paragraph-usage/{type}` | Detail view |

## Permissions Reference

| Permission | Description |
|------------|-------------|
| `access paragraph usage dashboard` | View dashboard and reports |

## File Locations

| What | Where |
|------|-------|
| Module | `/modules/contrib/paragraph_usage_dashboard` |
| Service | `src/Service/ParagraphUsageCollector.php` |
| Controllers | `src/Controller/*.php` |
| Templates | `templates/*.html.twig` |
| CSS | `css/dashboard.css` |
| JS | `js/dashboard.js` |

## Support Resources

- **Documentation:** See README.md in module directory
- **Issue Queue:** https://www.drupal.org/project/issues/paragraph_usage_dashboard
- **Source Code:** https://git.drupalcode.org/project/paragraph_usage_dashboard

## Next Steps

1. ✅ Install and enable module
2. ✅ Grant permissions
3. ✅ View dashboard
4. ✅ Try filtering paragraph types
5. ✅ Click a paragraph type to see details
6. ✅ Use insights to improve content strategy

## Questions?

Check the full README.md for detailed documentation or visit the issue queue for support.
