# Paragraph Usage Dashboard

A Drupal 11 contrib module that provides a comprehensive visual dashboard showing where each Paragraph Type is used across your site.

## Features

- **Visual Dashboard** - Admin interface at `/admin/reports/paragraph-usage`
- **Paragraph Type Icons** - Displays the configured icon for each paragraph type
- **Content Type Usage** - Shows which content types use each paragraph
- **Path Aliases** - Lists actual path aliases instead of node IDs
- **View Links** - Quick access to view parent entities
- **Paragraph Type Filter** - Multi-select filter to show only specific paragraph types
- **Drill-Down Detail View** - Detailed page showing all instances of a specific paragraph type
- **Modern Drupal 11 Architecture** - Uses OOP hooks, dependency injection, services, and controllers

## Requirements

- Drupal: ^11
- Paragraphs module

## Installation

1. Download and place this module in your `modules/contrib` directory
2. Enable the module: `drush en paragraph_usage_dashboard`
3. Grant the "Access paragraph usage dashboard" permission to appropriate roles
4. Navigate to `/admin/reports/paragraph-usage` to view the dashboard

## Usage

### Main Dashboard

The main dashboard displays a table with the following columns:

- **Icon** - The paragraph type icon (if configured)
- **Paragraph Type** - The name of the paragraph type (clickable for detail view)
- **Used in Content Type(s)** - Comma-separated list of content types using this paragraph
- **Path Alias(es)** - Path aliases of parent entities (up to 5, with count of additional)
- **View** - Link to view the first parent entity

### Filtering

Use the filter form to select specific paragraph types to display. The selection persists across page loads.

### Detail View

Click on any paragraph type name to see a detailed view showing:

- Entity title
- Content type/bundle
- Field name where the paragraph is used
- Path alias
- View link for each instance

## Architecture

This module follows modern Drupal 11 best practices:

### Services

- `ParagraphUsageCollector` - Core service that scans entities and collects usage data

### Controllers

- `DashboardController` - Renders the main dashboard
- `ParagraphDetailController` - Renders the detail view for a specific paragraph type

### Forms

- `ParagraphFilterForm` - Filter form for selecting paragraph types

### Hooks

- `ThemeHook` - Implements theme hooks using OOP hook system

## Permissions

- `access paragraph usage dashboard` - Required to view the dashboard and reports

## Technical Details

### How It Works

1. Scans all entity types and bundles
2. Identifies fields of type `entity_reference_revisions` targeting paragraphs
3. Loads entities using those fields
4. Extracts paragraph type, parent entity info, and path aliases
5. Loads paragraph type icons from configuration
6. Displays aggregated data in a filterable table

### Path Alias Extraction

The module uses `path_alias.manager` service to convert internal paths to aliases:

```php
$alias = $this->pathAliasManager->getAliasByPath('/node/123');
```

### Icon Loading

Icons are loaded from the paragraph type configuration:

```php
$icon_uuid = $paragraph_type->get('icon_uuid');
$files = $this->entityTypeManager
  ->getStorage('file')
  ->loadByProperties(['uuid' => $icon_uuid]);
```

## Contributing

This module is designed for contribution to drupal.org. Please follow Drupal coding standards and submit patches through the issue queue.

## License

GPL-2.0-or-later

## Maintainers

- Created for Drupal 11 contrib
