<?php

namespace Drupal\paragraph_usage_dashboard\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for theme system.
 */
class ThemeHook {

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme(): array {
    return [
      'paragraph_usage_dashboard' => [
        'variables' => [
          'usage_data' => [],
          'filter_form' => NULL,
        ],
        'template' => 'paragraph-usage-dashboard',
      ],
      'paragraph_usage_detail' => [
        'variables' => [
          'paragraph_type' => NULL,
          'entities' => [],
        ],
        'template' => 'paragraph-usage-detail',
      ],
    ];
  }

}
