<?php

namespace Drupal\paragraphs_blokkli_transform;

use Drupal\paragraphs_blokkli\ParagraphMutationContextInterface;

/**
 * Interface for paragraph_host_transform plugins.
 */
interface ParagraphHostTransformInterface {

  /**
   * Get the plugin ID.
   *
   * @return string
   *   The plugin ID.
   */
  public function getPluginId(): string;

  /**
   * Returns the translated plugin label.
   *
   * @return string
   *   The translated title.
   */
  public function label(): string;

  /**
   * Returns the translated plugin description.
   *
   * @return string|null
   *   The translated description.
   */
  public function getDescription(): ?string;

  /**
   * Whether the result of the transform plugin can be previewed.
   *
   * @return bool
   *   TRUE if the transform can be previewed.
   */
  public function allowPreview(): bool;

  /**
   * Transform the host entity.
   *
   * @param ParagraphMutationContextInterface $context
   *   The paragraph mutation context.
   * @param array $userConfig
   *   The user config.
   */
  public function transform(ParagraphMutationContextInterface $context, array $userConfig);

}
