<?php

namespace Drupal\paragraphs_blokkli;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * ParagraphMutation plugin manager.
 */
class ParagraphMutationPluginManager extends DefaultPluginManager {

  /**
   * Constructs ParagraphMutationPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/ParagraphsBlokkli/Mutation',
      $namespaces,
      $module_handler,
      'Drupal\paragraphs_blokkli\ParagraphMutationInterface',
      'Drupal\paragraphs_blokkli\Annotation\ParagraphMutation'
    );
    $this->alterInfo('paragraph_mutation_info');
    $this->setCacheBackend($cache_backend, 'paragraph_mutation_plugins');
  }

}
