<?php

namespace Drupal\Tests\paragraphs_blokkli\Kernel;

use Drupal\Core\Entity\FieldableEntityInterface;
use Drupal\paragraphs_blokkli\EditStateInterface;

/**
 * Test the custom user tokens.
 */
trait ParagraphsBlokkliTestTrait {

  /**
   * Get edit state.
   *
   * @param FieldableEntityInterface $entity
   */
  protected function getEditState(FieldableEntityInterface $entity): EditStateInterface|null {
    /** @var \Drupal\paragraphs_blokkli\ParagraphsBlokkliManager $manager */
    $manager = \Drupal::service('paragraphs_blokkli.manager');
    return $manager->getParagraphsEditState($entity);
  }

  /**
   * Persist the changes.
   *
   * @param EditStateInterface $editState
   * @param bool $force_reload
   */
  protected function paragraphsBlokkliPublish(EditStateInterface $editState, $force_reload = FALSE) {
    // Delete the entity cache, because some mutations (such as duplicating
    // paragraphs) cause nested fields to be emptied when building the mutated
    // state. When a test then publishes the edit state, we would be getting
    // the paragraph with empty fields from cache.
    /** @var \Drupal\Core\Cache\MemoryCache\LruMemoryCache $entityMemoryCache */
    $entityMemoryCache = \Drupal::service('entity.memory_cache');
    $entityMemoryCache->deleteAll();

    /** @var \Drupal\paragraphs_blokkli\ParagraphsBlokkliManager $manager */
    $manager = \Drupal::service('paragraphs_blokkli.manager');
    return $manager->publish($editState, $force_reload);
  }

  /**
   * Get test helper.
   *
   * @param EditStateInterface $editState
   *
   * @return ParagraphsBlokkliTestHelper
   *   The test helper.
   */
  protected function getParagraphsBlokkliTestHelper(EditStateInterface $editState): ParagraphsBlokkliTestHelper {
    return new ParagraphsBlokkliTestHelper($editState);
  }

}
