<?php

namespace Drupal\paragraphs_blokkli_graphql\Plugin\GraphQL\DataProducer;

use Drupal\Component\Plugin\PluginBase;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Drupal\paragraphs_blokkli\Model\PluginConfig\PluginConfigBuilder;
use Drupal\paragraphs_blokkli\ParagraphsBlokkliUserInputPluginInterface;

/**
 * Produce the config input for a plugin.
 *
 * @DataProducer(
 *   id = "paragraphs_blokkli_plugin_config_input",
 *   name = @Translation("Paragraphs Blokkli Plugin Config Input"),
 *   description = @Translation("Procudes an array of available plugin config input."),
 *   consumes = {
 *     "plugin" = @ContextDefinition("any",
 *       label = @Translation("The plugin.")
 *     ),
 *   },
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The config input.")
 *   ),
 * )
 */
class PluginConfigInput extends DataProducerPluginBase {

  /**
   * Resolver.
   */
  public function resolve(PluginBase $plugin) {
    if (!$plugin instanceof ParagraphsBlokkliUserInputPluginInterface) {
      return [];
    }

    $builder = new PluginConfigBuilder();
    $plugin->getUserInputConfiguration($builder);
    return $builder->toArray();
  }

}
