<?php

namespace Drupal\paragraphs_blokkli_scheduler\Plugin\GraphQL\DataProducer;

use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Drupal\paragraphs_blokkli\EditStateInterface;
use Drupal\paragraphs_blokkli\Entity\ParagraphsBlokkliEditState;

/**
 * Unschedule an edit state.
 *
 * @DataProducer(
 *   id = "paragraphs_blokkli_unschedule",
 *   name = @Translation("Paragraphs Blokkli Unschedule"),
 *   description = @Translation("Unschedule an edit state."),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The mutation result.")
 *   ),
 *   consumes = {
 *     "state" = @ContextDefinition("any",
 *       label = @Translation("The paragraphs edit state.")
 *     ),
 *   }
 * )
 */
class UnscheduleEditState extends DataProducerPluginBase {

  /**
   * Resolver.
   *
   * @param \Drupal\paragraphs_blokkli\EditStateInterface $state
   *   The edit state.
   */
  public function resolve(EditStateInterface $state) {
    assert($state instanceof ParagraphsBlokkliEditState);

    $hasValue = $state->get('publish_on')->first();

    // Only do something if it actually has a value.
    if ($hasValue) {
      $state->set('publish_on', NULL);
      $state->save();
    }

    return [
      'success' => TRUE,
      'state' => $state,
    ];
  }

}
