<?php

namespace Drupal\paragraphs_blokkli\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemList;

/**
 * Defines the 'paragraphs_blokkli_host_options' field item list class.
 */
class ParagraphsBlokkliHostOptionsFieldItemList extends FieldItemList {

  /**
   * Update or add an option.
   *
   * @param string $key
   *   The option key.
   * @param string $value
   *   The option value.
   *
   * @return $this
   *   The field list.
   */
  public function upsertOption(string $key, string $value): static {
    /** @var \Drupal\paragraphs_blokkli\Plugin\Field\FieldType\ParagraphsBlokkliHostOptions $item */
    foreach ($this->getIterator() as $item) {
      if ($item->getOptionKey() === $key) {
        $item->set('value', $value, FALSE);
        return $this;
      }
    }

    $this->appendItem([
      'key' => $key,
      'value' => $value,
    ]);

    return $this;
  }

  /**
   * Get the options as an array.
   *
   * @return array
   *   The keyed options.
   */
  public function getKeyedOptions(): array {
    $options = [];

    /** @var \Drupal\paragraphs_blokkli\Plugin\Field\FieldType\ParagraphsBlokkliHostOptions $item */
    foreach ($this->getIterator() as $item) {
      $options[$item->getOptionKey()] = $item->getOptionValue();
    }

    return $options;
  }

}
