<?php

namespace Drupal\paragraphs_blokkli\Plugin\ParagraphsBlokkli\Mutation;

use Drupal\paragraphs_blokkli\ParagraphMutationContextInterface;
use Drupal\paragraphs_blokkli\ParagraphMutationPluginBase;

/**
 * Update multiple options of the host at once.
 *
 * @ParagraphMutation(
 *   id = "update_host_options",
 *   label = @Translation("Update host options"),
 *   description = @Translation("Updates multiple options of the host."),
 *   arguments = {
 *     "items" = @ContextDefinition("map",
 *       label = @Translation("A list of arrays with keys: key and value."),
 *       multiple = TRUE
 *     ),
 *   }
 * )
 */
class UpdateHostOptions extends ParagraphMutationPluginBase {

  /**
   * Execute the mutation.
   *
   * @param ParagraphMutationContextInterface $context
   *   The paragraph mutation context.
   * @param array $items
   *   The options to update.
   */
  public function execute(ParagraphMutationContextInterface $context, array $items): void {
    foreach ($items as $item) {
      $key = $item['key'] ?? NULL;
      $value = $item['value'] ?? NULL;
      if ($key && $value !== NULL) {
        $context->updateHostOption($key, $value);
      }
    }
  }

}
