<?php

namespace Drupal\paragraphs_blokkli_graphql\Plugin\GraphQL\DataProducer;

use Drupal\graphql\GraphQL\Execution\FieldContext;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;

/**
 * Procudes the translation state.
 *
 * @DataProducer(
 *   id = "paragraphs_blokkli_media_library_results",
 *   name = @Translation("Paragraphs Blokkli Media Library Results"),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The bundles.")
 *   ),
 *   consumes = {
 *     "provider" = @ContextDefinition("any",
 *       label = @Translation("The search provider."),
 *     ),
 *     "text" = @ContextDefinition("string",
 *       label = @Translation("The search text."),
 *       required = FALSE,
 *     ),
 *     "bundle" = @ContextDefinition("string",
 *       label = @Translation("The bundle."),
 *       required = FALSE,
 *     ),
 *     "page" = @ContextDefinition("integer",
 *       label = @Translation("The page."),
 *       required = FALSE,
 *     ),
 *   }
 * )
 */
class ParagraphsBlokkliMediaLibraryResults extends DataProducerPluginBase {

  /**
   * Resolver.
   *
   * @param \Drupal\paragraphs_blokkli_search\ParagraphsBlokkliSearchPluginBase $provider
   * @param string|null $text
   * @param string|null $bundle
   * @param int|null $page
   * @param FieldContext|null $fieldContext
   */
  public function resolve($provider, string|null $text, string|null $bundle, int|null $page, FieldContext|null $fieldContext) {
    /** @var \Drupal\paragraphs_blokkli_search\ParagraphsBlokkliSearchMediaLibraryInterface $provider */
    return $provider->getMediaLibraryResults($text, $bundle, $page, $fieldContext);
  }

}
