<?php

namespace Drupal\paragraphs_blokkli_graphql\Plugin\GraphQL\DataProducer\Search;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\graphql\GraphQL\Execution\FieldContext;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Procudes a search provider.
 *
 * @DataProducer(
 *   id = "paragraphs_blokkli_load_search_provider",
 *   name = @Translation("Paragraphs Blokkli Load Search Provider"),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The search provider.")
 *   ),
 *   consumes = {
 *     "type" = @ContextDefinition("string",
 *       label = @Translation("The search provider type."),
 *     ),
 *   }
 * )
 */
class LoadSearchProvider extends DataProducerPluginBase implements ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
    );
  }

  /**
   * ParagraphsBlokkliMediaLibraryResults constructor.
   *
   * @param array $configuration
   *   The plugin configuration array.
   * @param string $pluginId
   *   The plugin id.
   * @param array $pluginDefinition
   *   The plugin definition array.
   * @param \Drupal\Core\Entity\EntityTypeManager $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(
    array $configuration,
    $pluginId,
    array $pluginDefinition,
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {
    parent::__construct($configuration, $pluginId, $pluginDefinition);
  }

  /**
   * Resolver.
   *
   * @param string $type
   * @param FieldContext $fieldContext
   */
  public function resolve(string $type, FieldContext $fieldContext) {
    if (!$this->entityTypeManager->hasDefinition('blokkli_search_provider')) {
      return NULL;
    }

    $storage = $this->entityTypeManager->getStorage('blokkli_search_provider');
    $fieldContext->addCacheTags($storage->getEntityType()->getListCacheTags());

    /** @var \Drupal\paragraphs_blokkli_search\Entity\BlokkliSearchProvider|null $searchEntity */
    $searchEntity = array_values($storage->loadByProperties([
      'search_type' => $type,
      'status' => TRUE,
    ]))[0] ?? NULL;

    if (!$searchEntity) {
      return NULL;
    }

    $plugin = $searchEntity->getSearchPlugin();

    if (!$plugin->supportsType($type)) {
      return NULL;
    }

    return $plugin;
  }

}
