<?php

declare(strict_types=1);

namespace Drupal\paragraphs_blokkli_search\Model;

/**
 * Provides an interface defining edit states search results.
 */
class EditStatesSearchResults {

  /**
   * Constructor.
   *
   * @param int $perPage
   *   The number of results per page.
   * @param int $total
   *   The total number of items.
   * @param string[] $ids
   *   The edit state IDs.
   * @param array $filters
   *   The available filters.
   */
  public function __construct(
    public readonly int $perPage,
    public readonly int $total,
    public readonly array $ids,
    public readonly array $filters,
  ) {}

}
