<?php

declare(strict_types=1);

namespace Drupal\paragraphs_blokkli_search;

use Drupal\Core\Cache\RefinableCacheableDependencyInterface;
use Drupal\paragraphs_blokkli_search\Model\EditStatesSearchResults;

/**
 * Interface for search plugins providing edit state search.
 */
interface ParagraphsBlokkliSearchEditStatesInterface {

  /**
   * The search type.
   */
  public const SEARCH_TYPE = 'edit_states';

  /**
   * Get the results for edit states.
   *
   * @param int|null $page
   *   The current page.
   * @param \Drupal\Core\Cache\RefinableCacheableDependencyInterface|null $metadata
   *   The cache metadata.
   *
   * @return \Drupal\paragraphs_blokkli_search\Model\EditStatesSearchResults
   *   The edit states results.
   */
  public function getEditStatesSearchResults(?int $page = NULL, ?RefinableCacheableDependencyInterface $metadata = NULL): EditStatesSearchResults;

}
