<?php

namespace Drupal\paragraphs_blokkli_transform;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Component\Uuid\UuidInterface;
use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Entity\FieldableEntityInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\paragraphs_blokkli\ParagraphsBlokkliApplicablePluginInterface;
use Drupal\paragraphs_blokkli\ParagraphsBlokkliPluginTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for paragraph_host_transform plugins.
 */
abstract class ParagraphHostTransformPluginBase extends PluginBase implements ParagraphHostTransformInterface, ContainerFactoryPluginInterface, ParagraphsBlokkliApplicablePluginInterface {

  use DependencySerializationTrait;
  use ParagraphsBlokkliPluginTrait;

  /**
   * The UUID service.
   */
  protected UuidInterface $uuidHelper;

  /**
   * The plugin ID.
   *
   * @var string
   */
  protected $pluginId;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('uuid')
    );
  }

  /**
   * Convert constructor.
   *
   * @param array $configuration
   *   The plugin configuration array.
   * @param string $pluginId
   *   The plugin id.
   * @param array $pluginDefinition
   *   The plugin definition array.
   * @param UuidInterface $uuidHelper
   *   The UUID helper.
   */
  public function __construct(
    array $configuration,
    $pluginId,
    array $pluginDefinition,
    UuidInterface $uuidHelper,
  ) {
    parent::__construct($configuration, $pluginId, $pluginDefinition);
    $this->uuidHelper = $uuidHelper;
    $this->pluginId = $pluginId;
  }

  /**
   * {@inheritdoc}
   */
  public function getPluginId(): string {
    return (string) $this->pluginId;
  }

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription(): ?string {
    $description = $this->pluginDefinition['description'] ?? NULL;
    if ($description) {
      return (string) $description;
    }

    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function allowPreview(): bool {
    return !empty($this->pluginDefinition['allowPreview']);
  }

  /**
   * {@inheritdoc}
   */
  public function applies(FieldableEntityInterface $hostEntity, string $langcode): bool {
    return TRUE;
  }

}
