<?php

namespace Drupal\paragraphs_blokkli\Model\PluginConfig;

/**
 * Checkbox input configuration.
 */
final class CheckboxInput extends ConfigInputBase {

  /**
   * The checkbox label (displayed next to the checkbox).
   *
   * @var string
   */
  protected string $checkboxLabel = '';

  /**
   * Sets the checkbox label.
   *
   * @param string $label
   *   The label displayed next to the checkbox.
   *
   * @return $this
   */
  public function checkboxLabel(string $label): static {
    $this->checkboxLabel = $label;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getType(): string {
    return 'checkbox';
  }

  /**
   * Gets the checkbox label.
   *
   * @return string
   *   The checkbox label.
   */
  public function getCheckboxLabel(): string {
    return $this->checkboxLabel;
  }

  /**
   * {@inheritdoc}
   */
  public function toArray(): array {
    $data = parent::toArray();
    $data['checkboxLabel'] = $this->checkboxLabel;
    return $data;
  }

}
