<?php

namespace Drupal\paragraphs_blokkli\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'paragraphs_blokkli_host_options' field type.
 *
 * @FieldType(
 *   id = "paragraphs_blokkli_host_options",
 *   label = @Translation("Paragraphs Blokkli Host Options"),
 *   module = "paragraphs_blokkli",
 *   description = @Translation("Stores the options from the blökkli editor."),
 *   cardinality = -1,
 *   list_class = "\Drupal\paragraphs_blokkli\Plugin\Field\FieldType\ParagraphsBlokkliHostOptionsFieldItemList",
 *   column_groups = {
 *     "key" = {
 *       "label" = @Translation("Key"),
 *       "translatable" = FALSE
 *     },
 *     "value" = {
 *       "label" = @Translation("Value"),
 *       "translatable" = FALSE
 *     },
 *   }
 * )
 */
class ParagraphsBlokkliHostOptions extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    return [
      'columns' => [
        'key' => [
          'type' => 'varchar',
          'length' => 255,
        ],
        'value' => [
          'type' => 'varchar',
          'length' => 255,
          'default value' => '',
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties['key'] = DataDefinition::create('string')->setLabel(t('Key'));
    $properties['value'] = DataDefinition::create('string')->setLabel(t('Value'));
    return $properties;
  }

  /**
   * Get the option value.
   *
   * @return string|null
   *   The option value.
   */
  public function getOptionValue(): ?string {
    return $this->get('value')->getValue();
  }

  /**
   * Get the option key.
   *
   * @return string
   *   The option key.
   */
  public function getOptionKey(): string {
    return $this->get('key')->getValue();
  }

}
