(function (Drupal, drupalSettings) {
  Drupal.behaviors.paragraphsClipboardVisibility = {
    attach(context) {
      const fieldAccess = drupalSettings.paragraphsClipboard?.fields || {};

      Object.entries(fieldAccess).forEach(([fieldId, state]) => {
        const access = state.hasAccess;
        const buttons = once(`clipboard-button-${fieldId}`, `.clipboard-button-${fieldId}`, context);

        buttons.forEach(function (el) {
          el.disabled = !access;
        });
      });
    },
  };
})(Drupal, drupalSettings);
