<?php

namespace Drupal\layout_paragraphs_clipboard\Controller;

use Drupal\layout_paragraphs\Controller\ComponentFormController;
use Drupal\layout_paragraphs\Event\LayoutParagraphsComponentDefaultsEvent;
use Drupal\layout_paragraphs\LayoutParagraphsLayout;
use Drupal\layout_paragraphs_clipboard\PasteClipboardTrait;
use Drupal\paragraphs_clipboard\ParagraphsClipboardService;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class definition for ComponentFormController.
 */
class PasteClipboardFormController extends ComponentFormController {
  use PasteClipboardTrait;

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->initClipboardServices($container);
    return $instance;
  }

  /**
   * Responds with a component insert form.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request.
   * @param \Drupal\layout_paragraphs\LayoutParagraphsLayout $layout_paragraphs_layout
   *   The layout paragraphs layout object.
   *
   * @return array|\Drupal\Core\Ajax\AjaxResponse
   *   A build array or Ajax response.
   */
  public function pasteClipboardForm(Request $request, LayoutParagraphsLayout $layout_paragraphs_layout) {
    $paragraph = $this->getParagraphFromClipboard(ParagraphsClipboardService::CLIPBOARD_UUID_KEY);
    if (!$paragraph) {
      return $this->displayErrorMessage($this->t('No paragraph found in the clipboard.'));
    }
    $paragraph_type_id = $paragraph->bundle();

    $parent_uuid = $request->query->get('parent_uuid');
    $region = $request->query->get('region');
    $sibling_uuid = $request->query->get('sibling_uuid');
    $placement = $request->query->get('placement');

    $event = new LayoutParagraphsComponentDefaultsEvent($paragraph_type_id, []);
    $this->eventDispatcher->dispatch($event, $event::EVENT_NAME);
    $paragraph_type = $this->entityTypeManager()
      ->getStorage('paragraphs_type')
      ->load($event->getParagraphTypeId());

    $form = $this->formBuilder()->getForm(
      $this->getPasteClipboardComponentFormClass(),
      $layout_paragraphs_layout,
      $paragraph_type,
      $parent_uuid,
      $region,
      $sibling_uuid,
      $placement,
      $event->getDefaultValues());

    return $this->openForm($form, $layout_paragraphs_layout);
  }

  /**
   * Returns the insert component form class.
   */
  protected function getPasteClipboardComponentFormClass() {
    return '\Drupal\layout_paragraphs_clipboard\Form\PasteClipboardComponentForm';
  }

}
