<?php

namespace Drupal\layout_paragraphs_clipboard\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\layout_paragraphs\Form\InsertComponentForm;
use Drupal\paragraphs\ParagraphsTypeInterface;
use Drupal\paragraphs_clipboard\ParagraphsClipboardService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class InsertComponentForm.
 *
 * Builds the form for inserting a new component.
 */
class PasteClipboardComponentForm extends InsertComponentForm {

  /**
   * Paragraphs Clipboard Service.
   *
   * @var \Drupal\paragraphs_clipboard\ParagraphsClipboardService
   */
  protected $paragraphsClipboard;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->paragraphsClipboard = $container->get('paragraphs_clipboard.paragraphs_clipboard_service');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  protected function buildComponentForm(array $form, FormStateInterface $form_state, string $form_display_mode = 'default') {
    $form = parent::buildComponentForm($form, $form_state, $form_display_mode);

    $form['actions']['submit']['#value'] = $this->t('Paste');

    return $form;
  }

  /**
   * Create the form title.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   *   The form title.
   */
  protected function formTitle() {
    return $this->t('Paste @label from clipboard', ['@label' => $this->paragraph->getParagraphType()->label()]);
  }

  /**
   * {@inheritDoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $langcode = $this->layoutParagraphsLayout->getEntity()->language()->getId();
    $paragraph_type = $this->paragraph->getParagraphType();
    $this->paragraph = parent::newParagraph($paragraph_type, $langcode);

    parent::submitForm($form, $form_state);
  }

  /**
   * Creates a new, empty paragraph empty of the provided type.
   *
   * @param \Drupal\paragraphs\ParagraphsTypeInterface $paragraph_type
   *   The paragraph type.
   * @param string $langcode
   *   The language code for the new paragraph.
   *
   * @return \Drupal\paragraphs\ParagraphInterface
   *   Paragraph from clipboard.
   */
  protected function newParagraph(ParagraphsTypeInterface $paragraph_type, string $langcode) {
    $paragraph = $this->paragraphsClipboard->getParagraphFromClipboard(ParagraphsClipboardService::CLIPBOARD_UUID_KEY);
    if (!$paragraph) {
      $paragraph = parent::newParagraph($paragraph_type, $langcode);
    }

    return $paragraph;
  }

}
