<?php

namespace Drupal\paragraphs_clipboard\Controller;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\MessageCommand;
use Drupal\Core\Controller\ControllerBase;
use Drupal\paragraphs\ParagraphInterface;
use Drupal\paragraphs_clipboard\ParagraphsClipboardService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class CopyClipboardController.
 *
 * Copy Paragraph component.
 */
class CopyClipboardController extends ControllerBase {

  /**
   * The clipboard service.
   *
   * @var \Drupal\paragraphs_clipboard\ParagraphsClipboardService
   */
  protected $clipboardService;

  /**
   * Constructs a new CopyClipboardController object.
   *
   * @param \Drupal\paragraphs_clipboard\ParagraphsClipboardService $clipboard_service
   *   The clipboard service.
   */
  public function __construct(ParagraphsClipboardService $clipboard_service) {
    $this->clipboardService = $clipboard_service;
  }

  /**
   * {@inheritDoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('paragraphs_clipboard.paragraphs_clipboard_service'),
    );
  }

  /**
   * Duplicates a component and returns appropriate response.
   *
   * @param \Drupal\paragraphs\ParagraphInterface $paragraph
   *   The paragraph entity to copy.
   *
   * @return array|\Drupal\Core\Ajax\AjaxResponse
   *   A build array or Ajax response.
   */
  public function copy(ParagraphInterface $paragraph) {
    $response = new AjaxResponse();

    $revision_id = $paragraph->getRevisionId();

    $clipboard_data = [
      'paragraph_id' => $paragraph,
      'revision_id' => $revision_id,
    ];

    $this->clipboardService->setClipboardData(ParagraphsClipboardService::CLIPBOARD_KEY, $clipboard_data);
    $response->addCommand(new MessageCommand('Paragraph has been copied to clipboard.', NULL, [], FALSE));

    return $response;
  }

}
