<?php

namespace Drupal\paragraphs_clipboard\Plugin\Field\FieldWidget;

use Drupal\Component\Utility\NestedArray;
use Drupal\Core\Form\FormStateInterface;
use Drupal\paragraphs\Plugin\Field\FieldWidget\ParagraphsWidget;

/**
 * Extends the ParagraphsWidget class to add custom functionality.
 */
class ParagraphsClipboardWidget extends ParagraphsWidget {

  /**
   * Prepares the widget state to add a new paragraph at a specific position.
   *
   * @param array $widget_state
   *   Widget state as reference, so that it can be updated.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   Form state.
   * @param array $element
   *   Element array.
   */
  public static function prepareClipboardDeltaPosition(array &$widget_state, FormStateInterface $form_state, array $element) {
    $field_path = array_merge($element['#field_parents'], [$element['#field_name']]);
    $add_more_delta = NestedArray::getValue($element, [
      'add_more',
      'add_more_delta',
      '#value',
    ]);

    parent::prepareDeltaPosition($widget_state, $form_state, $field_path, $add_more_delta);
  }

  /**
   * {@inheritdoc}
   */
  public static function addMoreAjax(array $form, FormStateInterface $form_state) {
    $trigger = $form_state->getTriggeringElement();
    $element = NestedArray::getValue($form, array_slice($trigger['#array_parents'], 0, -3));

    // Add a DIV around the delta receiving the Ajax effect.
    $delta = $element['#max_delta'];
    $element[$delta]['#prefix'] = '<div class="ajax-new-content">' . ($element[$delta]['#prefix'] ?? '');
    $element[$delta]['#suffix'] = ($element[$delta]['#suffix'] ?? '') . '</div>';

    // Clear the Add more delta.
    NestedArray::setValue(
      $element,
      ['add_more', 'add_more_delta', '#value'],
      ''
    );

    return $element;
  }

}
