<?php


namespace Drupal\Tests\paragraphs_field_validator\Kernel;


use Drupal\paragraphs\Entity\Paragraph;
use Drupal\Tests\paragraphs\Kernel\ParagraphsTestBase;


/**
 * Kernel test for FieldFormatConstraintValidator.
 *
 * @group paragraphs_field_validator
 */
class FieldFormatConstraintValidatorTest extends ParagraphsTestBase {


  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'paragraphs_field_validator',
    'paragraphs',
    'node',
  ];


  /**
   * Tests validation violation.
   */
  public function testValidation() {
    $paragraph = Paragraph::create([
      'type' => 'text',
      'field_text' => 'wrong-value',
    ]);
    $violations = $paragraph->validate();
    $this->assertIsIterable($violations);
  }
}
