<?php


namespace Drupal\Tests\paragraphs_field_validator\Functional;


use Drupal\Tests\BrowserTestBase;


/**
 * Functional test for the settings form.
 *
 * @group paragraphs_field_validator
 */
class SettingsFormTest extends BrowserTestBase {


  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'paragraphs_field_validator',
    'paragraphs',
    'node',
  ];


  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';


  /**
   * Tests access to the settings form.
   */
  public function testSettingsFormAccess() {
    $user = $this->drupalCreateUser(['administer site configuration']);
    $this->drupalLogin($user);
    $this->drupalGet('/admin/config/content/paragraphs-field-validator');
    $this->assertSession()->statusCodeEquals(200);
  }

}
