Paragraphs Field Validator
==========================

Provides configurable validation rules for fields inside **Paragraph** entities.

What it does
------------

*   Allows site builders to define rules that check paragraph field values based on conditions.

*   Example: If a _key field_ contains a specific text, then a _value field_ must match a given **regular expression**.


Features
--------

*   Rule configuration per paragraph bundle.

*   Conditional validation triggered by a _key field_ text match.

*   Case-insensitive matching support.

*   Optional restriction to specific nodes.

*   Configurable regex pattern and example message.


Requirements
------------

*   Drupal 10 or 11

*   [Paragraphs](https://www.drupal.org/project/paragraphs)


Installation
------------

1.  composer require drupal/paragraphs\_field\_validator

2.  drush en paragraphs\_field\_validator

3.  Go to **Configuration → Content authoring → Paragraphs Field Validator** and add validation rules.


Configuration
-------------

Each validation rule includes:

*   field\_bundle (string, required): Machine name of the paragraph bundle.

*   field\_key\_machine\_name (string, required): Machine name of the key field.

*   field\_key\_text (string, required): Text that must be matched in the key field (leave empty to always apply).

*   field\_value\_machine\_name (string, required): Machine name of the field to validate.

*   field\_value\_regex (string, required): Regular expression applied to the field value.

*   field\_regex\_example (string, required): Example value shown in error messages.

*   apply\_to\_nodes (array, optional): Node titles where this validation should apply. If empty, validation applies to all nodes.


Development
-----------

*   Follows PSR-4 and Drupal Coding Standards.

*   Tests are recommended:

  *   Kernel tests for the validator.

  *   Functional tests for the settings form.


License
-------

This project is licensed under the terms of the **GNU General Public License, version 2 or later (GPL-2.0-or-later)**. See the LICENSE.txt file for details.
