<?php

namespace Drupal\Tests\paragraphs_field_validator\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\Core\Url;

/**
 * Functional test for the Settings form of paragraphs_field_validator module.
 *
 * @group paragraphs_field_validator
 */
class SettingsFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'field',
    'text',
    'filter',
    'config',
    'node',
    'paragraphs',
    'paragraphs_field_validator',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test user with admin permissions.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->adminUser = $this->drupalCreateUser([
      'administer site configuration',
    ]);
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Tests access and basic rendering of the settings form.
   */
  public function testSettingsFormAccess(): void {
    // Create a content type "page" so nodes can be created.
    $this->drupalCreateContentType(['type' => 'page', 'name' => 'Page']);

    // Create a sample node so the form has something to list.
    $this->drupalCreateNode([
      'type' => 'page',
      'title' => 'Sample node',
    ]);

    // Visit the settings form route using its route name.
    $this->drupalGet(Url::fromRoute('paragraphs_field_validator.settings'));

    // Assert that the page loads successfully.
    $this->assertSession()->statusCodeEquals(200);

    // Assert that the page contains the expected form title.
    $this->assertSession()->pageTextContains('Paragraph Field Validator');
  }

}
