<?php

namespace Drupal\paragraphs_list_filter\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\paragraphs\Entity\ParagraphsType;

/**
 * Class ParagraphsListFilterForm.
 *
 * @package Drupal\paragraphs_list_filter\Form
 */
class ParagraphsListFilterForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'paragraphs_list_filter';
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $request = \Drupal::request();

    $form['filter'] = [
      '#type' => 'container',
      '#attributes' => [
        'class' => ['form--inline', 'clearfix'],
      ],
    ];

    // Fetch all paragraph types.
    $paragraph_types = ParagraphsType::loadMultiple();
    $options = [];
    $options[''] = '';
    foreach ($paragraph_types as $paragraph_type) {
      $options[$paragraph_type->id()] = $paragraph_type->id();
    }

    // Add a select field with the paragraph types.
    $form['filter']['id'] = [
      '#type' => 'select',
      '#title' => $this->t('Machine Name'),
      '#options' => $options,
      '#default_value' => $request->get('id') ?? '',
    ];

    $form['filter']['label'] = [
      '#type' => 'textfield',
      '#title' => 'Label',
      '#size' => 30,
      '#default_value' => $request->get('label') ?? '',
    ];

    $form['filter']['description'] = [
      '#type' => 'textfield',
      '#title' => 'Description',
      '#size' => 30,
      '#default_value' => $request->get('description') ?? '',
    ];

    // Dropdown for items per page.
    $form['filter']['items_per_page'] = [
      '#type' => 'select',
      '#title' => $this->t('Per Page'),
      '#options' => [
        10 => $this->t('10'),
        20 => $this->t('20'),
        30 => $this->t('30'),
        50 => $this->t('50'),
        100 => $this->t('100'),
        200 => $this->t('200'),
        500 => $this->t('500'),
      ],
      // Default to 20 items per page.
      '#default_value' => $request->get('items_per_page') ?? 50,
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => 'Filter',
      '#attributes' => [
        'style' => "margin: 0;",
      ],
    ];
    $form['#method'] = "get";

    return $form;
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

  }

}
