# Paragraphs List Filter Drupal Module

## Overview

**Paragraphs List Filter** is a Drupal module that enhances the management of Paragraphs entities by providing advanced filtering and listing capabilities. It is designed for site builders and editors who work with complex content structures using the Paragraphs module, making it easier to find, filter, and manage Paragraphs items in the admin interface.

---

## Features

- **Custom List Builder:** Displays Paragraphs entities in a configurable, filterable list.
- **Advanced Filtering:** Filter Paragraphs by type, field values, or other criteria using a user-friendly form.
- **Admin UI Integration:** Seamlessly integrates with the Drupal admin interface for easy access.
- **Custom Styling:** Includes CSS for improved usability and appearance of the list and filter form.

---

## Folder Structure

```
paragraphs_list_filter/
├── LICENSE.txt
├── paragraphs_list_filter.info.yml
├── paragraphs_list_filter.libraries.yml
├── paragraphs_list_filter.module
├── css/
│   └── style.css
└── src/
    ├── Entity/
    │   └── ListBuilder/
    │       └── ParagraphsListFilterBuilder.php   # Custom list builder for Paragraphs
    └── Form/
        └── ParagraphsListFilterForm.php          # Form for filtering Paragraphs
```

---

## Main Functionalities

### 1. Paragraphs List Builder

- **ParagraphsListFilterBuilder.php:**  
  Implements a custom list builder for Paragraphs entities.  
  - Displays a table or list of Paragraphs with relevant fields and metadata.
  - Supports sorting and pagination.
  - Integrates with the filter form for dynamic results.

### 2. Filtering Form

- **ParagraphsListFilterForm.php:**  
  Provides a form for filtering Paragraphs entities.  
  - Allows filtering by Paragraph type, field values, or other attributes.
  - Submits filter criteria to update the list builder results.
  - Designed for ease of use and quick access to relevant Paragraphs.

### 3. Custom Styling

- **css/style.css:**  
  Enhances the appearance and usability of the list and filter form in the admin UI.

---

## Usage

### Viewing and Filtering Paragraphs

1. Navigate to the Paragraphs List Filter page in the Drupal admin menu.
2. Use the filter form to select Paragraph type or enter field values.
3. View the filtered list of Paragraphs entities.
4. Sort and paginate results as needed.

### Configuration

- No special configuration is required. The module works out-of-the-box for sites using the Paragraphs module.
- You can customize the CSS in `css/style.css` to match your site's admin theme.

---

## Requirements

- Drupal 9 or 10
- Paragraphs module enabled
- PHP 7.4+
- Appropriate permissions to view and manage Paragraphs entities

---

## Extending

- Add new filter criteria by extending `ParagraphsListFilterForm.php`.
- Customize list columns or display logic in `ParagraphsListFilterBuilder.php`.
- Adjust styling in `css/style.css` for improved UX.

---

## License

See `LICENSE.txt`.

---

## Support

For issues or feature requests, open an issue in your repository or contact the maintainer.
