<?php

namespace Drupal\paragraphs_list_filter\Entity\ListBuilder;

use Drupal\paragraphs\Controller\ParagraphsTypeListBuilder;
use Drupal\paragraphs_list_filter\Form\ParagraphsListFilterForm;

/**
 * Defines a class to build a listing of paragraph filters.
 */
class ParagraphsListFilterBuilder extends ParagraphsTypeListBuilder {

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build['form'] = \Drupal::formBuilder()->getForm(ParagraphsListFilterForm::class);
    $build += parent::render();
    $build['pager'] = ['#type' => 'pager'];
    $build['#attached']['library'][] = 'paragraphs_list_filter/paragraphs_list_filter.style';

    return $build;
  }

  /**
   * Loads a list of paragraph type entities with filtering and pagination.
   */
  public function load() {
    // Get filtered list of paragraph type IDs.
    $filters = ['id', 'label', 'description'];
    $query = $this->getStorage()->getQuery()->accessCheck(TRUE);
    foreach ($filters as $filter) {
      $value = \Drupal::request()->query->get($filter);
      if ($value !== NULL && $value !== '') {
        $query->condition($filter, $value, 'CONTAINS');
      }
    }
    $ids = $query->execute();
    // Initialize pager.
    $total = count($ids);
    $limit = $this->getLimit();
    $currentPage = \Drupal::service('pager.manager')->createPager($total, $limit)->getCurrentPage();
    // Load only the entities for the current page.
    $currentPageIds = array_slice($ids, $currentPage * $limit, $limit);
    return $this->getStorage()->loadMultiple($currentPageIds);
  }

  /**
   * Get current items per page limit from the request.
   */
  private function getLimit(): int {
    $value = \Drupal::request()->query->get('limit');
    return is_numeric($value) ? intval($value) : 50;
  }

}
