# Paragraphs Source Edit

Enable editing the **source** translation of a Paragraph at the same URL pattern used by asymmetric translation widgets:

```
/paragraphs/{paragraph}/translations/edit/{language}
```

This module extends the route so that when `{language}` is the **source** language (e.g., `en`), it renders the **normal paragraph edit form** for that language, instead of 404’ing. Non-source languages (e.g., `fr`) keep working exactly as before.

---

## Why?

With `paragraphs_asymmetric_translation_widgets` enabled, Drupal typically only exposes a translation edit route for **non-source** languages. Source edits are expected to happen **via the parent entity** (node/media/block) and not directly on the paragraph. This is painful when:

- a paragraph is temporarily **orphaned** (no parent);
- you use a **Paragraphs Library** and need a direct link to edit the source;
- you want parity between source and translation edit links in the UI.

This module unlocks the source edit path while preserving permissions and cacheability.

---

## Requirements

- Drupal **10 or 11**
- Module: **Paragraphs**
- Module: **Content Translation**
- Module: **paragraphs_asymmetric_translation_widgets** (the route we extend)

> PHP 8.2+ supported and tested.

---

## Installation

Via Composer (recommended for contrib):

```bash
composer require drupal/paragraphs_source_edit
drush en paragraphs_source_edit -y
drush cr
```

> If installing from a tarball/zip, place the module under
> `web/modules/contrib/paragraphs_source_edit` (or `modules/contrib/...`), then enable it.

---

## How it works

- The module alters the existing route created by **paragraphs_asymmetric_translation_widgets** for:
  ```
  /paragraphs/{paragraph}/translations/edit/{language}
  ```
- It swaps in a small controller that:
  - accepts `{language}` as a `LanguageInterface` (param converter);
  - computes whether the requested language is the **source** language for the paragraph;
  - renders the **normal** entity edit form bound to that language (source or translation);
  - keeps **normal update access** checks and adds proper cacheability metadata.

No configuration is required.

---

## Usage

After enabling the module:

- **Source language edit (e.g., English):**
  ```
  /en/paragraphs/{pid}/translations/edit/en
  ```
  → shows the regular paragraph edit form in English.

- **Non-source translation edit (e.g., French):**
  ```
  /fr/paragraphs/{pid}/translations/edit/fr
  ```
  → behaves the same as asymmetric widgets (edit FR).

> Include your site’s language prefix (`/en`, `/fr`) if you use language-prefixed URLs.

---

## Access & Security

- The route **still requires** that the user can **update** the paragraph (`$paragraph->access('update', …)`).
- If the user lacks permission, Drupal continues to respond with a **404** (as usual for entity edit routes).
- Cacheability:
  - Access result is merged with entity cacheability.
  - Cached **per permissions**.

---

## Verifying it’s active

List the route and confirm it points to the module’s controller:

```bash
drush core:route | grep -E "/paragraphs/.*/translations/edit"
```

You should see the path above, with `_controller` set to the module’s controller.

---

## Edge cases & Notes

- **Orphan paragraphs** (no parent entity)  
  Previously, EN (source) 404’d; with this module you can now edit the source directly, which also helps recovery workflows.

- **Paragraphs Library**  
  Works fine alongside library UIs. You may still prefer editing via the library parent for authoring experience; this module simply adds the direct source edit route when needed.

- **Language availability**  
  `{language}` must be a valid, enabled site language (the param converter ensures this).

- **Nothing else changes**  
  We don’t add new local tasks, alter canonical paths, or change edit behavior outside the specific route above.

---

## Uninstall

```bash
drush pmu paragraphs_source_edit -y
drush cr
```

The `/translations/edit/{language}` route reverts to its original behavior (source language will no longer be editable at that path).

---

## Troubleshooting

- **404 (still) on EN:**  
  Check permissions (`administer paragraphs` is not strictly required; **update** access on the paragraph is). Also ensure you included the proper language prefix (e.g., `/en/...`).

- **Route not found / not altered:**  
  Different module versions may register slightly different route names. Clear caches and re-check:
  ```bash
  drush core:route | grep -E "/paragraphs/.*/translations/edit"
  ```
  If nothing matches, confirm `paragraphs_asymmetric_translation_widgets` is enabled and provides that path.

- **Theme looks non-admin:**  
  Ensure the route has `_admin_route: TRUE` (the module sets this when altering the route).

---

## Compatibility

- Tested on Drupal **10.x** and **11.x**
- PHP **8.2** and **8.3**
- Works with Paragraphs + Content Translation + asymmetric widgets.
- Should not conflict with Paragraphs Library or other admin UIs; this module only adjusts a single route/controller.

---

## Development & Tests (nice-to-have)

If you want to add automated tests:

- **Kernel/Functional test plan:**
  1. Create a paragraph with EN source; create FR translation.
  2. Hit `/paragraphs/{pid}/translations/edit/en` → assert 200 and edit form renders.
  3. Hit `/paragraphs/{pid}/translations/edit/fr` → assert 200 and edit form renders.
  4. Remove update permission → assert 404.
  5. (Optional) Orphan the paragraph → assert EN edit still works (200).

---

## Maintainers

- Initial author: Your Name / Org  
- Contributions welcome via merge requests / patches.

---

## License

GPL-2.0-or-later  
See the included `LICENSE.txt` or <https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html>.

---

## Project Page / Issues

- Packagist/Composer: `drupal/paragraphs_source_edit` (after publishing)
- Drupal.org project page & issue queue: *(add URL once created)*

---

### Changelog

- **1.x-dev** — Initial release: add source-language edit support to `/paragraphs/{paragraph}/translations/edit/{language}`.
