# Paragraphs Table Module

The Paragraphs Table module is a versatile Drupal extension that shares
similarities with the [Field Collection Table](https://www.drupal.org/project/field_collection_table)
module. It offers robust features for managing and presenting data in a
table format, providing an efficient way to structure and display
information on your Drupal website.

With the Paragraphs Table module, you can:

**Table Mode:** Easily create and manage tables in both new and edit modes.

**Flexible Display:** Choose between vertical or horizontal table display
in your views.

**Ajax Support:** Handle large tables with Ajax, ensuring optimal performance.

**Operations:** Perform common table operations like modify, delete & duplicate,
similar to Field Collection Table.

**Support [Display Suite](https://www.drupal.org/project/ds):** Seamlessly
integrate the module with Display Suite to enhance your content layout.

**Support [Field Permission](https://www.drupal.org/project/field_permissions):** Control table access using Drupal's field permission settings.

**Support [Datatable](https://datatables.net/):** enhanced data manipulation.

**Support [Bootstraptable](https://bootstrap-table.com/):** polished & responsive table design.

**Support [Google Chart](https://developers-dot-devsite-v2-prod.appspot.com/chart/interactive/docs/gallery):** Utilize Google Charts for data visualization.
Be sure to verify your data using the arrayToDataTable examples.

#### Functionality Note
It's important to note that, some functions may still be a work in progress.
We encourage you to propose solutions or contribute to help improve the
module's functionality, with the aim of achieving a user experience similar
to that of the Field Collection Table module.

### Note
For optimal usage:

* Add a new form page for paragraphs in view display mode,
which operates smoothly with Ajax.
* Be aware that edit/duplicate forms in view mode may not work as expected
with image fields, and the reasons for this behavior are being investigated.

For the best results, consider using a [Bootstrap 5 admin](https://www.drupal.org/project/bootstrap5_admin) theme
to complement the module's features.


#### Support and Appreciation
If you find the Paragraphs Table module valuable and would like to show
your appreciation, consider [buying a cup of coffee ☕](https://www.buymeacoffee.com/nbao) for the developer.
