(function ($, Drupal, once) {
  'use strict';

  /**
   * Provides global select-all and alignment-sync functionality.
   */
  Drupal.behaviors.paragraphsTitleManagerBehavior = {
    attach: function (context) {

      // ---------------------------------------------------------------
      // GLOBAL SELECT ALL / DESELECT ALL BUTTON
      // ---------------------------------------------------------------
      $(once('ptm-select-all', '.ptm-select-all-button', context)).on('click', function (event) {
        event.preventDefault();

        var $button = $(this);
        var selectLabel = $button.data('label-select') || 'Select All';
        var deselectLabel = $button.data('label-deselect') || 'Deselect All';

        var $checkboxes = $(context).find('.ptm-title-checkbox');

        // Determine if selecting or deselecting.
        var anyUnchecked = $checkboxes.filter(function () {
          return !$(this).prop('checked');
        }).length > 0;

        var selecting = anyUnchecked;

        // Toggle all checkboxes.
        $checkboxes.each(function () {
          var $cb = $(this);
          $cb.prop('checked', selecting);

          // Trigger Drupal.states visibility updates.
          this.dispatchEvent(new Event('change', { bubbles: true }));
        });

        // Update button label.
        $button.val(selecting ? deselectLabel : selectLabel);
        $button.text(selecting ? deselectLabel : selectLabel);

        // Show/hide global alignment dropdown.
        var $globalSelect = $(context).find('.ptm-global-alignment');
        if (selecting) {
          $globalSelect.removeClass('d-none');
        }
        else {
          $globalSelect.addClass('d-none').val('');
        }
      });

      // ---------------------------------------------------------------
      // GLOBAL ALIGNMENT SELECT — applies alignment to all checked fields
      // ---------------------------------------------------------------
      $(once('ptm-global-align', '.ptm-global-alignment', context)).on('change', function () {
        var $select = $(this);
        var alignment = $select.val();

        if (!alignment) {
          return;
        }

        var $checkboxes = $(context).find('.ptm-title-checkbox:checked');

        $checkboxes.each(function () {
          var $cb = $(this);
          var name = $cb.attr('name'); // Example: all_wrapper[wrapper][hero][field_title_enabled]
          if (!name) {
            return;
          }

          // Build the corresponding alignment field name.
          var alignName = name.replace('_enabled]', '_alignment]');

          // Escape the characters for jQuery selector.
          var escaped = alignName.replace(/([\[\]\\])/g, '\\$1');

          var $alignSelect = $(context).find('select[name="' + escaped + '"]');

          if ($alignSelect.length) {
            $alignSelect.val(alignment);
            $alignSelect.trigger('change');
          }
        });
      });

    }
  };

})(jQuery, Drupal, once);
