<?php

namespace Drupal\paragraphs_title_manager\Helper;

use Drupal\Core\Database\Database;

/**
 * Helper class for Paragraphs Title Manager.
 *
 * Provides reusable utility functions without requiring services.
 */
class ParagraphsTitleManagerHelper
{

    /**
     * Returns alignment options from the database.
     *
     * @return array
     *   An associative array where key = alignment value, value = label.
     */
    public static function getAlignmentOptions()
    {
        $options = [];

        $rows = Database::getConnection()
            ->select('paragraphs_title_manager_alignment_options', 'o')
            ->fields('o', ['key', 'label'])
            ->execute()
            ->fetchAll();

        foreach ($rows as $row) {
            $options[$row->key] = $row->label;
        }

        return $options;
    }
}
