# Paragraphs Title Manager – License & Security Policy

**License: GPL-2.0-or-later**

This module is distributed under the terms of the GNU General Public License, either version 2 of the license, or (at your option) any later version. This license is identical to the one used by Drupal core and all official contrib modules, ensuring complete compatibility with the Drupal ecosystem.

---

## 📜 1. GNU GENERAL PUBLIC LICENSE (GPL-2.0-or-later)

Copyright © Contributors

This program is free software; you can redistribute it and/or modify  
it under the terms of the GNU General Public License as published by  
the Free Software Foundation; either version 2 of the License, or  
(at your option) any later version.

This program is distributed in the hope that it will be useful,  
but WITHOUT ANY WARRANTY; without even the implied warranty of  
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License  
along with this program.  
If not, see:  
https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

---

## 🔐 2. Drupal Security Team Guidelines

This module follows the official security processes defined by the Drupal Security Team:

- **Drupal Security Policy:**  
  https://www.drupal.org/drupal-security-team/security-policy

- **Reporting a Security Issue:**  
  https://www.drupal.org/security-team/how-to-report-a-security-issue

- **Responsible Disclosure Policy:**  
  https://www.drupal.org/drupal-security-team/responsible-disclosure

The maintainers of this module actively monitor security advisories and adhere to Drupal’s standard processes for responsible disclosure, patching, and release management.

---

## 🛡️ 3. Security Statement for This Module

This module does **not** handle:

- authentication  
- user credentials  
- sensitive or personal data  

It interacts only with:

- Paragraph entities  
- Alignment strings  
- UI configuration states  

### Data stored in the database is non-sensitive:

- Paragraph **bundle** name  
- **Field machine** name  
- Boolean **enabled/disabled** flag  
- Alignment **string**  

### ✔ Safe by Design

- No elevated database access beyond Drupal API  
- All DB operations wrapped in `try/catch`  
- No unsafe HTML or arbitrary raw input is stored  
- No unsanitized output is rendered  

### ✔ Permission Controlled

Only users with the permission:


may access configuration.

---

## 📘 4. Security Expectations for Site Builders

For best security practice:

- Keep **Drupal core up-to-date**
- Update **Paragraphs module**
- Restrict configuration access to trusted users
- Use proper role-based permissions
- Monitor your site using:
  - Acquia Insight  
  - Drupal’s Status Report  
  - `composer audit`

---

## 🧩 5. Recommended Hardening Practices

Although this module is safe, we recommend:

- Use HTTPS everywhere
- Ensure secure PHP versions
- Avoid insecure file permissions (never `777`)
- Maintain automated database backups
- Use a WAF (Web Application Firewall)
- Monitor logs for abnormal activity
- Do not assign admin roles to unverified users

---

## 🛠️ 6. Contribution and Patch Submission Guidelines

Contributions **must**:

- Follow Drupal coding standards (PSR-4, PHPCS)
- Avoid raw SQL where Drupal APIs exist
- Not bypass Drupal permissions
- Maintain security best practices
- Avoid unsafe functions like `eval()`, `shell_exec()`, etc.
- Use safe error handling with `try/catch`

**Before submitting a patch:**

1. Review architecture  
2. Maintain backward compatibility  
3. Provide safe error handling  
4. Avoid exposing stack traces or debug info  
5. Test on Drupal 10 & 11  

---

## 📝 7. Warranty Disclaimer

To the maximum extent allowed by law:

- This module is provided **“as is”**  
- Without any warranty  
- Not guaranteed for any particular purpose  
- Maintainers are not liable for data loss or site damage  
- Site owners must test before deploying in production  

---

## 🌍 8. License Compatibility

GPL-2.0-or-later is compatible with:

- Drupal Core  
- All official Drupal contrib modules  
- All GPL-compatible libraries  
- Composer-based distributions  

---

## 🧾 9. Full GPL-2.0 License Text (Required)

The full license text can be found at:

https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt

Install locally using:

